// Version 1.15.2 sunburst-chart - https://github.com/vasturiano/sunburst-chart
! function(t, n) {
    "object" == typeof exports && "undefined" != typeof module ? module.exports = n() : "function" == typeof define && define.amd ? define(n) : (t = "undefined" != typeof globalThis ? globalThis : t || self).Sunburst = n()
}(this, (function() {
    "use strict";

    function t(t) {
        return function(t) {
            if (Array.isArray(t)) return n(t)
        }(t) || function(t) {
            if ("undefined" != typeof Symbol && null != t[Symbol.iterator] || null != t["@@iterator"]) return Array.from(t)
        }(t) || function(t, e) {
            if (!t) return;
            if ("string" == typeof t) return n(t, e);
            var r = Object.prototype.toString.call(t).slice(8, -1);
            "Object" === r && t.constructor && (r = t.constructor.name);
            if ("Map" === r || "Set" === r) return Array.from(t);
            if ("Arguments" === r || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)) return n(t, e)
        }(t) || function() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }()
    }

    function n(t, n) {
        (null == n || n > t.length) && (n = t.length);
        for (var e = 0, r = new Array(n); e < n; e++) r[e] = t[e];
        return r
    }! function(t, n) {
        void 0 === n && (n = {});
        var e = n.insertAt;
        if (t && "undefined" != typeof document) {
            var r = document.head || document.getElementsByTagName("head")[0],
                i = document.createElement("style");
            i.type = "text/css", "top" === e && r.firstChild ? r.insertBefore(i, r.firstChild) : r.appendChild(i), i.styleSheet ? i.styleSheet.cssText = t : i.appendChild(document.createTextNode(t))
        }
    }(".sunburst-viz .slice path {\n  cursor: pointer;\n}\n\n.sunburst-viz text {\n  font-family: sans-serif;\n  font-size: 12px;\n  dominant-baseline: middle;\n  text-anchor: middle;\n  pointer-events: none;\n  fill: #222;\n}\n\n.sunburst-viz .text-contour {\n  fill: none;\n  stroke: white;\n  stroke-width: 5;\n  stroke-linejoin: 'round';\n}\n\n.sunburst-viz .main-arc {\n  stroke-width: 1px;\n  transition: opacity .4s;\n}\n\n.sunburst-viz .main-arc:hover {\n  opacity: 0.85;\n  transition: opacity .05s;\n}\n\n.sunburst-viz .hidden-arc {\n  fill: none;\n}\n\n.sunburst-viz {\n  position: relative;\n}\n\n.sunburst-tooltip {\n  display: none;\n  position: absolute;\n  max-width: 320px;\n  white-space: nowrap;\n  padding: 5px;\n  border-radius: 3px;\n  font: 12px sans-serif;\n  color: #eee;\n  background: rgba(0,0,0,0.65);\n  pointer-events: none;\n}\n\n.sunburst-tooltip .tooltip-title {\n  font-weight: bold;\n  text-align: center;\n  margin-bottom: 5px;\n}\n");
    var e = "http://www.w3.org/1999/xhtml",
        r = {
            svg: "http://www.w3.org/2000/svg",
            xhtml: e,
            xlink: "http://www.w3.org/1999/xlink",
            xml: "http://www.w3.org/XML/1998/namespace",
            xmlns: "http://www.w3.org/2000/xmlns/"
        };

    function i(t) {
        var n = t += "",
            e = n.indexOf(":");
        return e >= 0 && "xmlns" !== (n = t.slice(0, e)) && (t = t.slice(e + 1)), r.hasOwnProperty(n) ? {
            space: r[n],
            local: t
        } : t
    }

    function a(t) {
        return function() {
            var n = this.ownerDocument,
                r = this.namespaceURI;
            return r === e && n.documentElement.namespaceURI === e ? n.createElement(t) : n.createElementNS(r, t)
        }
    }

    function o(t) {
        return function() {
            return this.ownerDocument.createElementNS(t.space, t.local)
        }
    }

    function u(t) {
        var n = i(t);
        return (n.local ? o : a)(n)
    }

    function l() {}

    function s(t) {
        return null == t ? l : function() {
            return this.querySelector(t)
        }
    }

    function c(t) {
        return null == t ? [] : Array.isArray(t) ? t : Array.from(t)
    }

    function f() {
        return []
    }

    function h(t) {
        return null == t ? f : function() {
            return this.querySelectorAll(t)
        }
    }

    function p(t) {
        return function() {
            return this.matches(t)
        }
    }

    function d(t) {
        return function(n) {
            return n.matches(t)
        }
    }
    var y = Array.prototype.find;

    function v() {
        return this.firstElementChild
    }
    var g = Array.prototype.filter;

    function m() {
        return Array.from(this.children)
    }

    function _(t) {
        return new Array(t.length)
    }

    function w(t, n) {
        this.ownerDocument = t.ownerDocument, this.namespaceURI = t.namespaceURI, this._next = null, this._parent = t, this.__data__ = n
    }

    function x(t) {
        return function() {
            return t
        }
    }

    function b(t, n, e, r, i, a) {
        for (var o, u = 0, l = n.length, s = a.length; u < s; ++u)(o = n[u]) ? (o.__data__ = a[u], r[u] = o) : e[u] = new w(t, a[u]);
        for (; u < l; ++u)(o = n[u]) && (i[u] = o)
    }

    function M(t, n, e, r, i, a, o) {
        var u, l, s, c = new Map,
            f = n.length,
            h = a.length,
            p = new Array(f);
        for (u = 0; u < f; ++u)(l = n[u]) && (p[u] = s = o.call(l, l.__data__, u, n) + "", c.has(s) ? i[u] = l : c.set(s, l));
        for (u = 0; u < h; ++u) s = o.call(t, a[u], u, a) + "", (l = c.get(s)) ? (r[u] = l, l.__data__ = a[u], c.delete(s)) : e[u] = new w(t, a[u]);
        for (u = 0; u < f; ++u)(l = n[u]) && c.get(p[u]) === l && (i[u] = l)
    }

    function A(t) {
        return t.__data__
    }

    function N(t) {
        return "object" == typeof t && "length" in t ? t : Array.from(t)
    }

    function S(t, n) {
        return t < n ? -1 : t > n ? 1 : t >= n ? 0 : NaN
    }

    function k(t) {
        return function() {
            this.removeAttribute(t)
        }
    }

    function E(t) {
        return function() {
            this.removeAttributeNS(t.space, t.local)
        }
    }

    function C(t, n) {
        return function() {
            this.setAttribute(t, n)
        }
    }

    function T(t, n) {
        return function() {
            this.setAttributeNS(t.space, t.local, n)
        }
    }

    function P(t, n) {
        return function() {
            var e = n.apply(this, arguments);
            null == e ? this.removeAttribute(t) : this.setAttribute(t, e)
        }
    }

    function O(t, n) {
        return function() {
            var e = n.apply(this, arguments);
            null == e ? this.removeAttributeNS(t.space, t.local) : this.setAttributeNS(t.space, t.local, e)
        }
    }

    function R(t) {
        return t.ownerDocument && t.ownerDocument.defaultView || t.document && t || t.defaultView
    }

    function I(t) {
        return function() {
            this.style.removeProperty(t)
        }
    }

    function j(t, n, e) {
        return function() {
            this.style.setProperty(t, n, e)
        }
    }

    function q(t, n, e) {
        return function() {
            var r = n.apply(this, arguments);
            null == r ? this.style.removeProperty(t) : this.style.setProperty(t, r, e)
        }
    }

    function L(t, n) {
        return t.style.getPropertyValue(n) || R(t).getComputedStyle(t, null).getPropertyValue(n)
    }

    function z(t) {
        return function() {
            delete this[t]
        }
    }

    function D(t, n) {
        return function() {
            this[t] = n
        }
    }

    function B(t, n) {
        return function() {
            var e = n.apply(this, arguments);
            null == e ? delete this[t] : this[t] = e
        }
    }

    function X(t) {
        return t.trim().split(/^|\s+/)
    }

    function H(t) {
        return t.classList || new U(t)
    }

    function U(t) {
        this._node = t, this._names = X(t.getAttribute("class") || "")
    }

    function $(t, n) {
        for (var e = H(t), r = -1, i = n.length; ++r < i;) e.add(n[r])
    }

    function V(t, n) {
        for (var e = H(t), r = -1, i = n.length; ++r < i;) e.remove(n[r])
    }

    function Y(t) {
        return function() {
            $(this, t)
        }
    }

    function F(t) {
        return function() {
            V(this, t)
        }
    }

    function G(t, n) {
        return function() {
            (n.apply(this, arguments) ? $ : V)(this, t)
        }
    }

    function Z() {
        this.textContent = ""
    }

    function W(t) {
        return function() {
            this.textContent = t
        }
    }

    function K(t) {
        return function() {
            var n = t.apply(this, arguments);
            this.textContent = null == n ? "" : n
        }
    }

    function Q() {
        this.innerHTML = ""
    }

    function J(t) {
        return function() {
            this.innerHTML = t
        }
    }

    function tt(t) {
        return function() {
            var n = t.apply(this, arguments);
            this.innerHTML = null == n ? "" : n
        }
    }

    function nt() {
        this.nextSibling && this.parentNode.appendChild(this)
    }

    function et() {
        this.previousSibling && this.parentNode.insertBefore(this, this.parentNode.firstChild)
    }

    function rt() {
        return null
    }

    function it() {
        var t = this.parentNode;
        t && t.removeChild(this)
    }

    function at() {
        var t = this.cloneNode(!1),
            n = this.parentNode;
        return n ? n.insertBefore(t, this.nextSibling) : t
    }

    function ot() {
        var t = this.cloneNode(!0),
            n = this.parentNode;
        return n ? n.insertBefore(t, this.nextSibling) : t
    }

    function ut(t) {
        return t.trim().split(/^|\s+/).map((function(t) {
            var n = "",
                e = t.indexOf(".");
            return e >= 0 && (n = t.slice(e + 1), t = t.slice(0, e)), {
                type: t,
                name: n
            }
        }))
    }

    function lt(t) {
        return function() {
            var n = this.__on;
            if (n) {
                for (var e, r = 0, i = -1, a = n.length; r < a; ++r) e = n[r], t.type && e.type !== t.type || e.name !== t.name ? n[++i] = e : this.removeEventListener(e.type, e.listener, e.options);
                ++i ? n.length = i : delete this.__on
            }
        }
    }

    function st(t, n, e) {
        return function() {
            var r, i = this.__on,
                a = function(t) {
                    return function(n) {
                        t.call(this, n, this.__data__)
                    }
                }(n);
            if (i)
                for (var o = 0, u = i.length; o < u; ++o)
                    if ((r = i[o]).type === t.type && r.name === t.name) return this.removeEventListener(r.type, r.listener, r.options), this.addEventListener(r.type, r.listener = a, r.options = e), void(r.value = n);
            this.addEventListener(t.type, a, e), r = {
                type: t.type,
                name: t.name,
                value: n,
                listener: a,
                options: e
            }, i ? i.push(r) : this.__on = [r]
        }
    }

    function ct(t, n, e) {
        var r = R(t),
            i = r.CustomEvent;
        "function" == typeof i ? i = new i(n, e) : (i = r.document.createEvent("Event"), e ? (i.initEvent(n, e.bubbles, e.cancelable), i.detail = e.detail) : i.initEvent(n, !1, !1)), t.dispatchEvent(i)
    }

    function ft(t, n) {
        return function() {
            return ct(this, t, n)
        }
    }

    function ht(t, n) {
        return function() {
            return ct(this, t, n.apply(this, arguments))
        }
    }
    w.prototype = {
        constructor: w,
        appendChild: function(t) {
            return this._parent.insertBefore(t, this._next)
        },
        insertBefore: function(t, n) {
            return this._parent.insertBefore(t, n)
        },
        querySelector: function(t) {
            return this._parent.querySelector(t)
        },
        querySelectorAll: function(t) {
            return this._parent.querySelectorAll(t)
        }
    }, U.prototype = {
        add: function(t) {
            this._names.indexOf(t) < 0 && (this._names.push(t), this._node.setAttribute("class", this._names.join(" ")))
        },
        remove: function(t) {
            var n = this._names.indexOf(t);
            n >= 0 && (this._names.splice(n, 1), this._node.setAttribute("class", this._names.join(" ")))
        },
        contains: function(t) {
            return this._names.indexOf(t) >= 0
        }
    };
    var pt = [null];

    function dt(t, n) {
        this._groups = t, this._parents = n
    }

    function yt() {
        return new dt([
            [document.documentElement]
        ], pt)
    }

    function vt(t, n) {
        return null == t || null == n ? NaN : t < n ? -1 : t > n ? 1 : t >= n ? 0 : NaN
    }

    function gt(t) {
        let n = t,
            e = t,
            r = t;

        function i(t, n, i = 0, a = t.length) {
            if (i < a) {
                if (0 !== e(n, n)) return a;
                do {
                    const e = i + a >>> 1;
                    r(t[e], n) < 0 ? i = e + 1 : a = e
                } while (i < a)
            }
            return i
        }
        return 1 === t.length && (n = (n, e) => t(n) - e, e = vt, r = (n, e) => vt(t(n), e)), {
            left: i,
            center: function(t, e, r = 0, a = t.length) {
                const o = i(t, e, r, a - 1);
                return o > r && n(t[o - 1], e) > -n(t[o], e) ? o - 1 : o
            },
            right: function(t, n, i = 0, a = t.length) {
                if (i < a) {
                    if (0 !== e(n, n)) return a;
                    do {
                        const e = i + a >>> 1;
                        r(t[e], n) <= 0 ? i = e + 1 : a = e
                    } while (i < a)
                }
                return i
            }
        }
    }
    dt.prototype = yt.prototype = {
        constructor: dt,
        select: function(t) {
            "function" != typeof t && (t = s(t));
            for (var n = this._groups, e = n.length, r = new Array(e), i = 0; i < e; ++i)
                for (var a, o, u = n[i], l = u.length, c = r[i] = new Array(l), f = 0; f < l; ++f)(a = u[f]) && (o = t.call(a, a.__data__, f, u)) && ("__data__" in a && (o.__data__ = a.__data__), c[f] = o);
            return new dt(r, this._parents)
        },
        selectAll: function(t) {
            t = "function" == typeof t ? function(t) {
                return function() {
                    return c(t.apply(this, arguments))
                }
            }(t) : h(t);
            for (var n = this._groups, e = n.length, r = [], i = [], a = 0; a < e; ++a)
                for (var o, u = n[a], l = u.length, s = 0; s < l; ++s)(o = u[s]) && (r.push(t.call(o, o.__data__, s, u)), i.push(o));
            return new dt(r, i)
        },
        selectChild: function(t) {
            return this.select(null == t ? v : function(t) {
                return function() {
                    return y.call(this.children, t)
                }
            }("function" == typeof t ? t : d(t)))
        },
        selectChildren: function(t) {
            return this.selectAll(null == t ? m : function(t) {
                return function() {
                    return g.call(this.children, t)
                }
            }("function" == typeof t ? t : d(t)))
        },
        filter: function(t) {
            "function" != typeof t && (t = p(t));
            for (var n = this._groups, e = n.length, r = new Array(e), i = 0; i < e; ++i)
                for (var a, o = n[i], u = o.length, l = r[i] = [], s = 0; s < u; ++s)(a = o[s]) && t.call(a, a.__data__, s, o) && l.push(a);
            return new dt(r, this._parents)
        },
        data: function(t, n) {
            if (!arguments.length) return Array.from(this, A);
            var e = n ? M : b,
                r = this._parents,
                i = this._groups;
            "function" != typeof t && (t = x(t));
            for (var a = i.length, o = new Array(a), u = new Array(a), l = new Array(a), s = 0; s < a; ++s) {
                var c = r[s],
                    f = i[s],
                    h = f.length,
                    p = N(t.call(c, c && c.__data__, s, r)),
                    d = p.length,
                    y = u[s] = new Array(d),
                    v = o[s] = new Array(d),
                    g = l[s] = new Array(h);
                e(c, f, y, v, g, p, n);
                for (var m, _, w = 0, S = 0; w < d; ++w)
                    if (m = y[w]) {
                        for (w >= S && (S = w + 1); !(_ = v[S]) && ++S < d;);
                        m._next = _ || null
                    }
            }
            return (o = new dt(o, r))._enter = u, o._exit = l, o
        },
        enter: function() {
            return new dt(this._enter || this._groups.map(_), this._parents)
        },
        exit: function() {
            return new dt(this._exit || this._groups.map(_), this._parents)
        },
        join: function(t, n, e) {
            var r = this.enter(),
                i = this,
                a = this.exit();
            return "function" == typeof t ? (r = t(r)) && (r = r.selection()) : r = r.append(t + ""), null != n && (i = n(i)) && (i = i.selection()), null == e ? a.remove() : e(a), r && i ? r.merge(i).order() : i
        },
        merge: function(t) {
            for (var n = t.selection ? t.selection() : t, e = this._groups, r = n._groups, i = e.length, a = r.length, o = Math.min(i, a), u = new Array(i), l = 0; l < o; ++l)
                for (var s, c = e[l], f = r[l], h = c.length, p = u[l] = new Array(h), d = 0; d < h; ++d)(s = c[d] || f[d]) && (p[d] = s);
            for (; l < i; ++l) u[l] = e[l];
            return new dt(u, this._parents)
        },
        selection: function() {
            return this
        },
        order: function() {
            for (var t = this._groups, n = -1, e = t.length; ++n < e;)
                for (var r, i = t[n], a = i.length - 1, o = i[a]; --a >= 0;)(r = i[a]) && (o && 4 ^ r.compareDocumentPosition(o) && o.parentNode.insertBefore(r, o), o = r);
            return this
        },
        sort: function(t) {
            function n(n, e) {
                return n && e ? t(n.__data__, e.__data__) : !n - !e
            }
            t || (t = S);
            for (var e = this._groups, r = e.length, i = new Array(r), a = 0; a < r; ++a) {
                for (var o, u = e[a], l = u.length, s = i[a] = new Array(l), c = 0; c < l; ++c)(o = u[c]) && (s[c] = o);
                s.sort(n)
            }
            return new dt(i, this._parents).order()
        },
        call: function() {
            var t = arguments[0];
            return arguments[0] = this, t.apply(null, arguments), this
        },
        nodes: function() {
            return Array.from(this)
        },
        node: function() {
            for (var t = this._groups, n = 0, e = t.length; n < e; ++n)
                for (var r = t[n], i = 0, a = r.length; i < a; ++i) {
                    var o = r[i];
                    if (o) return o
                }
            return null
        },
        size: function() {
            let t = 0;
            for (const n of this) ++t;
            return t
        },
        empty: function() {
            return !this.node()
        },
        each: function(t) {
            for (var n = this._groups, e = 0, r = n.length; e < r; ++e)
                for (var i, a = n[e], o = 0, u = a.length; o < u; ++o)(i = a[o]) && t.call(i, i.__data__, o, a);
            return this
        },
        attr: function(t, n) {
            var e = i(t);
            if (arguments.length < 2) {
                var r = this.node();
                return e.local ? r.getAttributeNS(e.space, e.local) : r.getAttribute(e)
            }
            return this.each((null == n ? e.local ? E : k : "function" == typeof n ? e.local ? O : P : e.local ? T : C)(e, n))
        },
        style: function(t, n, e) {
            return arguments.length > 1 ? this.each((null == n ? I : "function" == typeof n ? q : j)(t, n, null == e ? "" : e)) : L(this.node(), t)
        },
        property: function(t, n) {
            return arguments.length > 1 ? this.each((null == n ? z : "function" == typeof n ? B : D)(t, n)) : this.node()[t]
        },
        classed: function(t, n) {
            var e = X(t + "");
            if (arguments.length < 2) {
                for (var r = H(this.node()), i = -1, a = e.length; ++i < a;)
                    if (!r.contains(e[i])) return !1;
                return !0
            }
            return this.each(("function" == typeof n ? G : n ? Y : F)(e, n))
        },
        text: function(t) {
            return arguments.length ? this.each(null == t ? Z : ("function" == typeof t ? K : W)(t)) : this.node().textContent
        },
        html: function(t) {
            return arguments.length ? this.each(null == t ? Q : ("function" == typeof t ? tt : J)(t)) : this.node().innerHTML
        },
        raise: function() {
            return this.each(nt)
        },
        lower: function() {
            return this.each(et)
        },
        append: function(t) {
            var n = "function" == typeof t ? t : u(t);
            return this.select((function() {
                return this.appendChild(n.apply(this, arguments))
            }))
        },
        insert: function(t, n) {
            var e = "function" == typeof t ? t : u(t),
                r = null == n ? rt : "function" == typeof n ? n : s(n);
            return this.select((function() {
                return this.insertBefore(e.apply(this, arguments), r.apply(this, arguments) || null)
            }))
        },
        remove: function() {
            return this.each(it)
        },
        clone: function(t) {
            return this.select(t ? ot : at)
        },
        datum: function(t) {
            return arguments.length ? this.property("__data__", t) : this.node().__data__
        },
        on: function(t, n, e) {
            var r, i, a = ut(t + ""),
                o = a.length;
            if (!(arguments.length < 2)) {
                for (u = n ? st : lt, r = 0; r < o; ++r) this.each(u(a[r], n, e));
                return this
            }
            var u = this.node().__on;
            if (u)
                for (var l, s = 0, c = u.length; s < c; ++s)
                    for (r = 0, l = u[s]; r < o; ++r)
                        if ((i = a[r]).type === l.type && i.name === l.name) return l.value
        },
        dispatch: function(t, n) {
            return this.each(("function" == typeof n ? ht : ft)(t, n))
        },
        [Symbol.iterator]: function*() {
            for (var t = this._groups, n = 0, e = t.length; n < e; ++n)
                for (var r, i = t[n], a = 0, o = i.length; a < o; ++a)(r = i[a]) && (yield r)
        }
    };
    const mt = gt(vt).right;
    gt((function(t) {
        return null === t ? NaN : +t
    })).center;
    var _t = mt,
        wt = Math.sqrt(50),
        xt = Math.sqrt(10),
        bt = Math.sqrt(2);

    function Mt(t, n, e) {
        var r = (n - t) / Math.max(0, e),
            i = Math.floor(Math.log(r) / Math.LN10),
            a = r / Math.pow(10, i);
        return i >= 0 ? (a >= wt ? 10 : a >= xt ? 5 : a >= bt ? 2 : 1) * Math.pow(10, i) : -Math.pow(10, -i) / (a >= wt ? 10 : a >= xt ? 5 : a >= bt ? 2 : 1)
    }

    function At(t, n) {
        switch (arguments.length) {
            case 0:
                break;
            case 1:
                this.range(t);
                break;
            default:
                this.range(n).domain(t)
        }
        return this
    }

    function Nt(t, n, e) {
        t.prototype = n.prototype = e, e.constructor = t
    }

    function St(t, n) {
        var e = Object.create(t.prototype);
        for (var r in n) e[r] = n[r];
        return e
    }

    function kt() {}
    var Et = .7,
        Ct = 1 / Et,
        Tt = "\\s*([+-]?\\d+)\\s*",
        Pt = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",
        Ot = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",
        Rt = /^#([0-9a-f]{3,8})$/,
        It = new RegExp("^rgb\\(" + [Tt, Tt, Tt] + "\\)$"),
        jt = new RegExp("^rgb\\(" + [Ot, Ot, Ot] + "\\)$"),
        qt = new RegExp("^rgba\\(" + [Tt, Tt, Tt, Pt] + "\\)$"),
        Lt = new RegExp("^rgba\\(" + [Ot, Ot, Ot, Pt] + "\\)$"),
        zt = new RegExp("^hsl\\(" + [Pt, Ot, Ot] + "\\)$"),
        Dt = new RegExp("^hsla\\(" + [Pt, Ot, Ot, Pt] + "\\)$"),
        Bt = {
            aliceblue: 15792383,
            antiquewhite: 16444375,
            aqua: 65535,
            aquamarine: 8388564,
            azure: 15794175,
            beige: 16119260,
            bisque: 16770244,
            black: 0,
            blanchedalmond: 16772045,
            blue: 255,
            blueviolet: 9055202,
            brown: 10824234,
            burlywood: 14596231,
            cadetblue: 6266528,
            chartreuse: 8388352,
            chocolate: 13789470,
            coral: 16744272,
            cornflowerblue: 6591981,
            cornsilk: 16775388,
            crimson: 14423100,
            cyan: 65535,
            darkblue: 139,
            darkcyan: 35723,
            darkgoldenrod: 12092939,
            darkgray: 11119017,
            darkgreen: 25600,
            darkgrey: 11119017,
            darkkhaki: 12433259,
            darkmagenta: 9109643,
            darkolivegreen: 5597999,
            darkorange: 16747520,
            darkorchid: 10040012,
            darkred: 9109504,
            darksalmon: 15308410,
            darkseagreen: 9419919,
            darkslateblue: 4734347,
            darkslategray: 3100495,
            darkslategrey: 3100495,
            darkturquoise: 52945,
            darkviolet: 9699539,
            deeppink: 16716947,
            deepskyblue: 49151,
            dimgray: 6908265,
            dimgrey: 6908265,
            dodgerblue: 2003199,
            firebrick: 11674146,
            floralwhite: 16775920,
            forestgreen: 2263842,
            fuchsia: 16711935,
            gainsboro: 14474460,
            ghostwhite: 16316671,
            gold: 16766720,
            goldenrod: 14329120,
            gray: 8421504,
            green: 32768,
            greenyellow: 11403055,
            grey: 8421504,
            honeydew: 15794160,
            hotpink: 16738740,
            indianred: 13458524,
            indigo: 4915330,
            ivory: 16777200,
            khaki: 15787660,
            lavender: 15132410,
            lavenderblush: 16773365,
            lawngreen: 8190976,
            lemonchiffon: 16775885,
            lightblue: 11393254,
            lightcoral: 15761536,
            lightcyan: 14745599,
            lightgoldenrodyellow: 16448210,
            lightgray: 13882323,
            lightgreen: 9498256,
            lightgrey: 13882323,
            lightpink: 16758465,
            lightsalmon: 16752762,
            lightseagreen: 2142890,
            lightskyblue: 8900346,
            lightslategray: 7833753,
            lightslategrey: 7833753,
            lightsteelblue: 11584734,
            lightyellow: 16777184,
            lime: 65280,
            limegreen: 3329330,
            linen: 16445670,
            magenta: 16711935,
            maroon: 8388608,
            mediumaquamarine: 6737322,
            mediumblue: 205,
            mediumorchid: 12211667,
            mediumpurple: 9662683,
            mediumseagreen: 3978097,
            mediumslateblue: 8087790,
            mediumspringgreen: 64154,
            mediumturquoise: 4772300,
            mediumvioletred: 13047173,
            midnightblue: 1644912,
            mintcream: 16121850,
            mistyrose: 16770273,
            moccasin: 16770229,
            navajowhite: 16768685,
            navy: 128,
            oldlace: 16643558,
            olive: 8421376,
            olivedrab: 7048739,
            orange: 16753920,
            orangered: 16729344,
            orchid: 14315734,
            palegoldenrod: 15657130,
            palegreen: 10025880,
            paleturquoise: 11529966,
            palevioletred: 14381203,
            papayawhip: 16773077,
            peachpuff: 16767673,
            peru: 13468991,
            pink: 16761035,
            plum: 14524637,
            powderblue: 11591910,
            purple: 8388736,
            rebeccapurple: 6697881,
            red: 16711680,
            rosybrown: 12357519,
            royalblue: 4286945,
            saddlebrown: 9127187,
            salmon: 16416882,
            sandybrown: 16032864,
            seagreen: 3050327,
            seashell: 16774638,
            sienna: 10506797,
            silver: 12632256,
            skyblue: 8900331,
            slateblue: 6970061,
            slategray: 7372944,
            slategrey: 7372944,
            snow: 16775930,
            springgreen: 65407,
            steelblue: 4620980,
            tan: 13808780,
            teal: 32896,
            thistle: 14204888,
            tomato: 16737095,
            turquoise: 4251856,
            violet: 15631086,
            wheat: 16113331,
            white: 16777215,
            whitesmoke: 16119285,
            yellow: 16776960,
            yellowgreen: 10145074
        };

    function Xt() {
        return this.rgb().formatHex()
    }

    function Ht() {
        return this.rgb().formatRgb()
    }

    function Ut(t) {
        var n, e;
        return t = (t + "").trim().toLowerCase(), (n = Rt.exec(t)) ? (e = n[1].length, n = parseInt(n[1], 16), 6 === e ? $t(n) : 3 === e ? new Gt(n >> 8 & 15 | n >> 4 & 240, n >> 4 & 15 | 240 & n, (15 & n) << 4 | 15 & n, 1) : 8 === e ? Vt(n >> 24 & 255, n >> 16 & 255, n >> 8 & 255, (255 & n) / 255) : 4 === e ? Vt(n >> 12 & 15 | n >> 8 & 240, n >> 8 & 15 | n >> 4 & 240, n >> 4 & 15 | 240 & n, ((15 & n) << 4 | 15 & n) / 255) : null) : (n = It.exec(t)) ? new Gt(n[1], n[2], n[3], 1) : (n = jt.exec(t)) ? new Gt(255 * n[1] / 100, 255 * n[2] / 100, 255 * n[3] / 100, 1) : (n = qt.exec(t)) ? Vt(n[1], n[2], n[3], n[4]) : (n = Lt.exec(t)) ? Vt(255 * n[1] / 100, 255 * n[2] / 100, 255 * n[3] / 100, n[4]) : (n = zt.exec(t)) ? Qt(n[1], n[2] / 100, n[3] / 100, 1) : (n = Dt.exec(t)) ? Qt(n[1], n[2] / 100, n[3] / 100, n[4]) : Bt.hasOwnProperty(t) ? $t(Bt[t]) : "transparent" === t ? new Gt(NaN, NaN, NaN, 0) : null
    }

    function $t(t) {
        return new Gt(t >> 16 & 255, t >> 8 & 255, 255 & t, 1)
    }

    function Vt(t, n, e, r) {
        return r <= 0 && (t = n = e = NaN), new Gt(t, n, e, r)
    }

    function Yt(t) {
        return t instanceof kt || (t = Ut(t)), t ? new Gt((t = t.rgb()).r, t.g, t.b, t.opacity) : new Gt
    }

    function Ft(t, n, e, r) {
        return 1 === arguments.length ? Yt(t) : new Gt(t, n, e, null == r ? 1 : r)
    }

    function Gt(t, n, e, r) {
        this.r = +t, this.g = +n, this.b = +e, this.opacity = +r
    }

    function Zt() {
        return "#" + Kt(this.r) + Kt(this.g) + Kt(this.b)
    }

    function Wt() {
        var t = this.opacity;
        return (1 === (t = isNaN(t) ? 1 : Math.max(0, Math.min(1, t))) ? "rgb(" : "rgba(") + Math.max(0, Math.min(255, Math.round(this.r) || 0)) + ", " + Math.max(0, Math.min(255, Math.round(this.g) || 0)) + ", " + Math.max(0, Math.min(255, Math.round(this.b) || 0)) + (1 === t ? ")" : ", " + t + ")")
    }

    function Kt(t) {
        return ((t = Math.max(0, Math.min(255, Math.round(t) || 0))) < 16 ? "0" : "") + t.toString(16)
    }

    function Qt(t, n, e, r) {
        return r <= 0 ? t = n = e = NaN : e <= 0 || e >= 1 ? t = n = NaN : n <= 0 && (t = NaN), new tn(t, n, e, r)
    }

    function Jt(t) {
        if (t instanceof tn) return new tn(t.h, t.s, t.l, t.opacity);
        if (t instanceof kt || (t = Ut(t)), !t) return new tn;
        if (t instanceof tn) return t;
        var n = (t = t.rgb()).r / 255,
            e = t.g / 255,
            r = t.b / 255,
            i = Math.min(n, e, r),
            a = Math.max(n, e, r),
            o = NaN,
            u = a - i,
            l = (a + i) / 2;
        return u ? (o = n === a ? (e - r) / u + 6 * (e < r) : e === a ? (r - n) / u + 2 : (n - e) / u + 4, u /= l < .5 ? a + i : 2 - a - i, o *= 60) : u = l > 0 && l < 1 ? 0 : o, new tn(o, u, l, t.opacity)
    }

    function tn(t, n, e, r) {
        this.h = +t, this.s = +n, this.l = +e, this.opacity = +r
    }

    function nn(t, n, e) {
        return 255 * (t < 60 ? n + (e - n) * t / 60 : t < 180 ? e : t < 240 ? n + (e - n) * (240 - t) / 60 : n)
    }
    Nt(kt, Ut, {
        copy: function(t) {
            return Object.assign(new this.constructor, this, t)
        },
        displayable: function() {
            return this.rgb().displayable()
        },
        hex: Xt,
        formatHex: Xt,
        formatHsl: function() {
            return Jt(this).formatHsl()
        },
        formatRgb: Ht,
        toString: Ht
    }), Nt(Gt, Ft, St(kt, {
        brighter: function(t) {
            return t = null == t ? Ct : Math.pow(Ct, t), new Gt(this.r * t, this.g * t, this.b * t, this.opacity)
        },
        darker: function(t) {
            return t = null == t ? Et : Math.pow(Et, t), new Gt(this.r * t, this.g * t, this.b * t, this.opacity)
        },
        rgb: function() {
            return this
        },
        displayable: function() {
            return -.5 <= this.r && this.r < 255.5 && -.5 <= this.g && this.g < 255.5 && -.5 <= this.b && this.b < 255.5 && 0 <= this.opacity && this.opacity <= 1
        },
        hex: Zt,
        formatHex: Zt,
        formatRgb: Wt,
        toString: Wt
    })), Nt(tn, (function(t, n, e, r) {
        return 1 === arguments.length ? Jt(t) : new tn(t, n, e, null == r ? 1 : r)
    }), St(kt, {
        brighter: function(t) {
            return t = null == t ? Ct : Math.pow(Ct, t), new tn(this.h, this.s, this.l * t, this.opacity)
        },
        darker: function(t) {
            return t = null == t ? Et : Math.pow(Et, t), new tn(this.h, this.s, this.l * t, this.opacity)
        },
        rgb: function() {
            var t = this.h % 360 + 360 * (this.h < 0),
                n = isNaN(t) || isNaN(this.s) ? 0 : this.s,
                e = this.l,
                r = e + (e < .5 ? e : 1 - e) * n,
                i = 2 * e - r;
            return new Gt(nn(t >= 240 ? t - 240 : t + 120, i, r), nn(t, i, r), nn(t < 120 ? t + 240 : t - 120, i, r), this.opacity)
        },
        displayable: function() {
            return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && 0 <= this.l && this.l <= 1 && 0 <= this.opacity && this.opacity <= 1
        },
        formatHsl: function() {
            var t = this.opacity;
            return (1 === (t = isNaN(t) ? 1 : Math.max(0, Math.min(1, t))) ? "hsl(" : "hsla(") + (this.h || 0) + ", " + 100 * (this.s || 0) + "%, " + 100 * (this.l || 0) + "%" + (1 === t ? ")" : ", " + t + ")")
        }
    }));
    var en = t => () => t;

    function rn(t) {
        return 1 == (t = +t) ? an : function(n, e) {
            return e - n ? function(t, n, e) {
                return t = Math.pow(t, e), n = Math.pow(n, e) - t, e = 1 / e,
                    function(r) {
                        return Math.pow(t + r * n, e)
                    }
            }(n, e, t) : en(isNaN(n) ? e : n)
        }
    }

    function an(t, n) {
        var e = n - t;
        return e ? function(t, n) {
            return function(e) {
                return t + e * n
            }
        }(t, e) : en(isNaN(t) ? n : t)
    }
    var on = function t(n) {
        var e = rn(n);

        function r(t, n) {
            var r = e((t = Ft(t)).r, (n = Ft(n)).r),
                i = e(t.g, n.g),
                a = e(t.b, n.b),
                o = an(t.opacity, n.opacity);
            return function(n) {
                return t.r = r(n), t.g = i(n), t.b = a(n), t.opacity = o(n), t + ""
            }
        }
        return r.gamma = t, r
    }(1);

    function un(t, n) {
        n || (n = []);
        var e, r = t ? Math.min(n.length, t.length) : 0,
            i = n.slice();
        return function(a) {
            for (e = 0; e < r; ++e) i[e] = t[e] * (1 - a) + n[e] * a;
            return i
        }
    }

    function ln(t, n) {
        var e, r = n ? n.length : 0,
            i = t ? Math.min(r, t.length) : 0,
            a = new Array(i),
            o = new Array(r);
        for (e = 0; e < i; ++e) a[e] = yn(t[e], n[e]);
        for (; e < r; ++e) o[e] = n[e];
        return function(t) {
            for (e = 0; e < i; ++e) o[e] = a[e](t);
            return o
        }
    }

    function sn(t, n) {
        var e = new Date;
        return t = +t, n = +n,
            function(r) {
                return e.setTime(t * (1 - r) + n * r), e
            }
    }

    function cn(t, n) {
        return t = +t, n = +n,
            function(e) {
                return t * (1 - e) + n * e
            }
    }

    function fn(t, n) {
        var e, r = {},
            i = {};
        for (e in null !== t && "object" == typeof t || (t = {}), null !== n && "object" == typeof n || (n = {}), n) e in t ? r[e] = yn(t[e], n[e]) : i[e] = n[e];
        return function(t) {
            for (e in r) i[e] = r[e](t);
            return i
        }
    }
    var hn = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,
        pn = new RegExp(hn.source, "g");

    function dn(t, n) {
        var e, r, i, a = hn.lastIndex = pn.lastIndex = 0,
            o = -1,
            u = [],
            l = [];
        for (t += "", n += "";
            (e = hn.exec(t)) && (r = pn.exec(n));)(i = r.index) > a && (i = n.slice(a, i), u[o] ? u[o] += i : u[++o] = i), (e = e[0]) === (r = r[0]) ? u[o] ? u[o] += r : u[++o] = r : (u[++o] = null, l.push({
            i: o,
            x: cn(e, r)
        })), a = pn.lastIndex;
        return a < n.length && (i = n.slice(a), u[o] ? u[o] += i : u[++o] = i), u.length < 2 ? l[0] ? function(t) {
            return function(n) {
                return t(n) + ""
            }
        }(l[0].x) : function(t) {
            return function() {
                return t
            }
        }(n) : (n = l.length, function(t) {
            for (var e, r = 0; r < n; ++r) u[(e = l[r]).i] = e.x(t);
            return u.join("")
        })
    }

    function yn(t, n) {
        var e, r, i = typeof n;
        return null == n || "boolean" === i ? en(n) : ("number" === i ? cn : "string" === i ? (e = Ut(n)) ? (n = e, on) : dn : n instanceof Ut ? on : n instanceof Date ? sn : (r = n, !ArrayBuffer.isView(r) || r instanceof DataView ? Array.isArray(n) ? ln : "function" != typeof n.valueOf && "function" != typeof n.toString || isNaN(n) ? fn : cn : un))(t, n)
    }

    function vn(t, n) {
        return t = +t, n = +n,
            function(e) {
                return Math.round(t * (1 - e) + n * e)
            }
    }
    var gn, mn = 180 / Math.PI,
        _n = {
            translateX: 0,
            translateY: 0,
            rotate: 0,
            skewX: 0,
            scaleX: 1,
            scaleY: 1
        };

    function wn(t, n, e, r, i, a) {
        var o, u, l;
        return (o = Math.sqrt(t * t + n * n)) && (t /= o, n /= o), (l = t * e + n * r) && (e -= t * l, r -= n * l), (u = Math.sqrt(e * e + r * r)) && (e /= u, r /= u, l /= u), t * r < n * e && (t = -t, n = -n, l = -l, o = -o), {
            translateX: i,
            translateY: a,
            rotate: Math.atan2(n, t) * mn,
            skewX: Math.atan(l) * mn,
            scaleX: o,
            scaleY: u
        }
    }

    function xn(t, n, e, r) {
        function i(t) {
            return t.length ? t.pop() + " " : ""
        }
        return function(a, o) {
            var u = [],
                l = [];
            return a = t(a), o = t(o),
                function(t, r, i, a, o, u) {
                    if (t !== i || r !== a) {
                        var l = o.push("translate(", null, n, null, e);
                        u.push({
                            i: l - 4,
                            x: cn(t, i)
                        }, {
                            i: l - 2,
                            x: cn(r, a)
                        })
                    } else(i || a) && o.push("translate(" + i + n + a + e)
                }(a.translateX, a.translateY, o.translateX, o.translateY, u, l),
                function(t, n, e, a) {
                    t !== n ? (t - n > 180 ? n += 360 : n - t > 180 && (t += 360), a.push({
                        i: e.push(i(e) + "rotate(", null, r) - 2,
                        x: cn(t, n)
                    })) : n && e.push(i(e) + "rotate(" + n + r)
                }(a.rotate, o.rotate, u, l),
                function(t, n, e, a) {
                    t !== n ? a.push({
                        i: e.push(i(e) + "skewX(", null, r) - 2,
                        x: cn(t, n)
                    }) : n && e.push(i(e) + "skewX(" + n + r)
                }(a.skewX, o.skewX, u, l),
                function(t, n, e, r, a, o) {
                    if (t !== e || n !== r) {
                        var u = a.push(i(a) + "scale(", null, ",", null, ")");
                        o.push({
                            i: u - 4,
                            x: cn(t, e)
                        }, {
                            i: u - 2,
                            x: cn(n, r)
                        })
                    } else 1 === e && 1 === r || a.push(i(a) + "scale(" + e + "," + r + ")")
                }(a.scaleX, a.scaleY, o.scaleX, o.scaleY, u, l), a = o = null,
                function(t) {
                    for (var n, e = -1, r = l.length; ++e < r;) u[(n = l[e]).i] = n.x(t);
                    return u.join("")
                }
        }
    }
    var bn = xn((function(t) {
            const n = new("function" == typeof DOMMatrix ? DOMMatrix : WebKitCSSMatrix)(t + "");
            return n.isIdentity ? _n : wn(n.a, n.b, n.c, n.d, n.e, n.f)
        }), "px, ", "px)", "deg)"),
        Mn = xn((function(t) {
            return null == t ? _n : (gn || (gn = document.createElementNS("http://www.w3.org/2000/svg", "g")), gn.setAttribute("transform", t), (t = gn.transform.baseVal.consolidate()) ? wn((t = t.matrix).a, t.b, t.c, t.d, t.e, t.f) : _n)
        }), ", ", ")", ")");

    function An(t) {
        return +t
    }
    var Nn = [0, 1];

    function Sn(t) {
        return t
    }

    function kn(t, n) {
        return (n -= t = +t) ? function(e) {
            return (e - t) / n
        } : (e = isNaN(n) ? NaN : .5, function() {
            return e
        });
        var e
    }

    function En(t, n, e) {
        var r = t[0],
            i = t[1],
            a = n[0],
            o = n[1];
        return i < r ? (r = kn(i, r), a = e(o, a)) : (r = kn(r, i), a = e(a, o)),
            function(t) {
                return a(r(t))
            }
    }

    function Cn(t, n, e) {
        var r = Math.min(t.length, n.length) - 1,
            i = new Array(r),
            a = new Array(r),
            o = -1;
        for (t[r] < t[0] && (t = t.slice().reverse(), n = n.slice().reverse()); ++o < r;) i[o] = kn(t[o], t[o + 1]), a[o] = e(n[o], n[o + 1]);
        return function(n) {
            var e = _t(t, n, 1, r) - 1;
            return a[e](i[e](n))
        }
    }

    function Tn(t, n) {
        return n.domain(t.domain()).range(t.range()).interpolate(t.interpolate()).clamp(t.clamp()).unknown(t.unknown())
    }

    function Pn() {
        var t, n, e, r, i, a, o = Nn,
            u = Nn,
            l = yn,
            s = Sn;

        function c() {
            var t, n, e, l = Math.min(o.length, u.length);
            return s !== Sn && (t = o[0], n = o[l - 1], t > n && (e = t, t = n, n = e), s = function(e) {
                return Math.max(t, Math.min(n, e))
            }), r = l > 2 ? Cn : En, i = a = null, f
        }

        function f(n) {
            return null == n || isNaN(n = +n) ? e : (i || (i = r(o.map(t), u, l)))(t(s(n)))
        }
        return f.invert = function(e) {
                return s(n((a || (a = r(u, o.map(t), cn)))(e)))
            }, f.domain = function(t) {
                return arguments.length ? (o = Array.from(t, An), c()) : o.slice()
            }, f.range = function(t) {
                return arguments.length ? (u = Array.from(t), c()) : u.slice()
            }, f.rangeRound = function(t) {
                return u = Array.from(t), l = vn, c()
            }, f.clamp = function(t) {
                return arguments.length ? (s = !!t || Sn, c()) : s !== Sn
            }, f.interpolate = function(t) {
                return arguments.length ? (l = t, c()) : l
            }, f.unknown = function(t) {
                return arguments.length ? (e = t, f) : e
            },
            function(e, r) {
                return t = e, n = r, c()
            }
    }

    function On() {
        return Pn()(Sn, Sn)
    }

    function Rn(t, n) {
        if ((e = (t = n ? t.toExponential(n - 1) : t.toExponential()).indexOf("e")) < 0) return null;
        var e, r = t.slice(0, e);
        return [r.length > 1 ? r[0] + r.slice(2) : r, +t.slice(e + 1)]
    }

    function In(t) {
        return (t = Rn(Math.abs(t))) ? t[1] : NaN
    }
    var jn, qn = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;

    function Ln(t) {
        if (!(n = qn.exec(t))) throw new Error("invalid format: " + t);
        var n;
        return new zn({
            fill: n[1],
            align: n[2],
            sign: n[3],
            symbol: n[4],
            zero: n[5],
            width: n[6],
            comma: n[7],
            precision: n[8] && n[8].slice(1),
            trim: n[9],
            type: n[10]
        })
    }

    function zn(t) {
        this.fill = void 0 === t.fill ? " " : t.fill + "", this.align = void 0 === t.align ? ">" : t.align + "", this.sign = void 0 === t.sign ? "-" : t.sign + "", this.symbol = void 0 === t.symbol ? "" : t.symbol + "", this.zero = !!t.zero, this.width = void 0 === t.width ? void 0 : +t.width, this.comma = !!t.comma, this.precision = void 0 === t.precision ? void 0 : +t.precision, this.trim = !!t.trim, this.type = void 0 === t.type ? "" : t.type + ""
    }

    function Dn(t, n) {
        var e = Rn(t, n);
        if (!e) return t + "";
        var r = e[0],
            i = e[1];
        return i < 0 ? "0." + new Array(-i).join("0") + r : r.length > i + 1 ? r.slice(0, i + 1) + "." + r.slice(i + 1) : r + new Array(i - r.length + 2).join("0")
    }
    Ln.prototype = zn.prototype, zn.prototype.toString = function() {
        return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (void 0 === this.width ? "" : Math.max(1, 0 | this.width)) + (this.comma ? "," : "") + (void 0 === this.precision ? "" : "." + Math.max(0, 0 | this.precision)) + (this.trim ? "~" : "") + this.type
    };
    var Bn = {
        "%": (t, n) => (100 * t).toFixed(n),
        b: t => Math.round(t).toString(2),
        c: t => t + "",
        d: function(t) {
            return Math.abs(t = Math.round(t)) >= 1e21 ? t.toLocaleString("en").replace(/,/g, "") : t.toString(10)
        },
        e: (t, n) => t.toExponential(n),
        f: (t, n) => t.toFixed(n),
        g: (t, n) => t.toPrecision(n),
        o: t => Math.round(t).toString(8),
        p: (t, n) => Dn(100 * t, n),
        r: Dn,
        s: function(t, n) {
            var e = Rn(t, n);
            if (!e) return t + "";
            var r = e[0],
                i = e[1],
                a = i - (jn = 3 * Math.max(-8, Math.min(8, Math.floor(i / 3)))) + 1,
                o = r.length;
            return a === o ? r : a > o ? r + new Array(a - o + 1).join("0") : a > 0 ? r.slice(0, a) + "." + r.slice(a) : "0." + new Array(1 - a).join("0") + Rn(t, Math.max(0, n + a - 1))[0]
        },
        X: t => Math.round(t).toString(16).toUpperCase(),
        x: t => Math.round(t).toString(16)
    };

    function Xn(t) {
        return t
    }
    var Hn, Un, $n, Vn = Array.prototype.map,
        Yn = ["y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];

    function Fn(t) {
        var n, e, r = void 0 === t.grouping || void 0 === t.thousands ? Xn : (n = Vn.call(t.grouping, Number), e = t.thousands + "", function(t, r) {
                for (var i = t.length, a = [], o = 0, u = n[0], l = 0; i > 0 && u > 0 && (l + u + 1 > r && (u = Math.max(1, r - l)), a.push(t.substring(i -= u, i + u)), !((l += u + 1) > r));) u = n[o = (o + 1) % n.length];
                return a.reverse().join(e)
            }),
            i = void 0 === t.currency ? "" : t.currency[0] + "",
            a = void 0 === t.currency ? "" : t.currency[1] + "",
            o = void 0 === t.decimal ? "." : t.decimal + "",
            u = void 0 === t.numerals ? Xn : function(t) {
                return function(n) {
                    return n.replace(/[0-9]/g, (function(n) {
                        return t[+n]
                    }))
                }
            }(Vn.call(t.numerals, String)),
            l = void 0 === t.percent ? "%" : t.percent + "",
            s = void 0 === t.minus ? "−" : t.minus + "",
            c = void 0 === t.nan ? "NaN" : t.nan + "";

        function f(t) {
            var n = (t = Ln(t)).fill,
                e = t.align,
                f = t.sign,
                h = t.symbol,
                p = t.zero,
                d = t.width,
                y = t.comma,
                v = t.precision,
                g = t.trim,
                m = t.type;
            "n" === m ? (y = !0, m = "g") : Bn[m] || (void 0 === v && (v = 12), g = !0, m = "g"), (p || "0" === n && "=" === e) && (p = !0, n = "0", e = "=");
            var _ = "$" === h ? i : "#" === h && /[boxX]/.test(m) ? "0" + m.toLowerCase() : "",
                w = "$" === h ? a : /[%p]/.test(m) ? l : "",
                x = Bn[m],
                b = /[defgprs%]/.test(m);

            function M(t) {
                var i, a, l, h = _,
                    M = w;
                if ("c" === m) M = x(t) + M, t = "";
                else {
                    var A = (t = +t) < 0 || 1 / t < 0;
                    if (t = isNaN(t) ? c : x(Math.abs(t), v), g && (t = function(t) {
                            t: for (var n, e = t.length, r = 1, i = -1; r < e; ++r) switch (t[r]) {
                                case ".":
                                    i = n = r;
                                    break;
                                case "0":
                                    0 === i && (i = r), n = r;
                                    break;
                                default:
                                    if (!+t[r]) break t;
                                    i > 0 && (i = 0)
                            }
                            return i > 0 ? t.slice(0, i) + t.slice(n + 1) : t
                        }(t)), A && 0 == +t && "+" !== f && (A = !1), h = (A ? "(" === f ? f : s : "-" === f || "(" === f ? "" : f) + h, M = ("s" === m ? Yn[8 + jn / 3] : "") + M + (A && "(" === f ? ")" : ""), b)
                        for (i = -1, a = t.length; ++i < a;)
                            if (48 > (l = t.charCodeAt(i)) || l > 57) {
                                M = (46 === l ? o + t.slice(i + 1) : t.slice(i)) + M, t = t.slice(0, i);
                                break
                            }
                }
                y && !p && (t = r(t, 1 / 0));
                var N = h.length + t.length + M.length,
                    S = N < d ? new Array(d - N + 1).join(n) : "";
                switch (y && p && (t = r(S + t, S.length ? d - M.length : 1 / 0), S = ""), e) {
                    case "<":
                        t = h + t + M + S;
                        break;
                    case "=":
                        t = h + S + t + M;
                        break;
                    case "^":
                        t = S.slice(0, N = S.length >> 1) + h + t + M + S.slice(N);
                        break;
                    default:
                        t = S + h + t + M
                }
                return u(t)
            }
            return v = void 0 === v ? 6 : /[gprs]/.test(m) ? Math.max(1, Math.min(21, v)) : Math.max(0, Math.min(20, v)), M.toString = function() {
                return t + ""
            }, M
        }
        return {
            format: f,
            formatPrefix: function(t, n) {
                var e = f(((t = Ln(t)).type = "f", t)),
                    r = 3 * Math.max(-8, Math.min(8, Math.floor(In(n) / 3))),
                    i = Math.pow(10, -r),
                    a = Yn[8 + r / 3];
                return function(t) {
                    return e(i * t) + a
                }
            }
        }
    }

    function Gn(t, n, e, r) {
        var i, a = function(t, n, e) {
            var r = Math.abs(n - t) / Math.max(0, e),
                i = Math.pow(10, Math.floor(Math.log(r) / Math.LN10)),
                a = r / i;
            return a >= wt ? i *= 10 : a >= xt ? i *= 5 : a >= bt && (i *= 2), n < t ? -i : i
        }(t, n, e);
        switch ((r = Ln(null == r ? ",f" : r)).type) {
            case "s":
                var o = Math.max(Math.abs(t), Math.abs(n));
                return null != r.precision || isNaN(i = function(t, n) {
                    return Math.max(0, 3 * Math.max(-8, Math.min(8, Math.floor(In(n) / 3))) - In(Math.abs(t)))
                }(a, o)) || (r.precision = i), $n(r, o);
            case "":
            case "e":
            case "g":
            case "p":
            case "r":
                null != r.precision || isNaN(i = function(t, n) {
                    return t = Math.abs(t), n = Math.abs(n) - t, Math.max(0, In(n) - In(t)) + 1
                }(a, Math.max(Math.abs(t), Math.abs(n)))) || (r.precision = i - ("e" === r.type));
                break;
            case "f":
            case "%":
                null != r.precision || isNaN(i = function(t) {
                    return Math.max(0, -In(Math.abs(t)))
                }(a)) || (r.precision = i - 2 * ("%" === r.type))
        }
        return Un(r)
    }

    function Zn(t) {
        var n = t.domain;
        return t.ticks = function(t) {
            var e = n();
            return function(t, n, e) {
                var r, i, a, o, u = -1;
                if (e = +e, (t = +t) == (n = +n) && e > 0) return [t];
                if ((r = n < t) && (i = t, t = n, n = i), 0 === (o = Mt(t, n, e)) || !isFinite(o)) return [];
                if (o > 0) {
                    let e = Math.round(t / o),
                        r = Math.round(n / o);
                    for (e * o < t && ++e, r * o > n && --r, a = new Array(i = r - e + 1); ++u < i;) a[u] = (e + u) * o
                } else {
                    o = -o;
                    let e = Math.round(t * o),
                        r = Math.round(n * o);
                    for (e / o < t && ++e, r / o > n && --r, a = new Array(i = r - e + 1); ++u < i;) a[u] = (e + u) / o
                }
                return r && a.reverse(), a
            }(e[0], e[e.length - 1], null == t ? 10 : t)
        }, t.tickFormat = function(t, e) {
            var r = n();
            return Gn(r[0], r[r.length - 1], null == t ? 10 : t, e)
        }, t.nice = function(e) {
            null == e && (e = 10);
            var r, i, a = n(),
                o = 0,
                u = a.length - 1,
                l = a[o],
                s = a[u],
                c = 10;
            for (s < l && (i = l, l = s, s = i, i = o, o = u, u = i); c-- > 0;) {
                if ((i = Mt(l, s, e)) === r) return a[o] = l, a[u] = s, n(a);
                if (i > 0) l = Math.floor(l / i) * i, s = Math.ceil(s / i) * i;
                else {
                    if (!(i < 0)) break;
                    l = Math.ceil(l * i) / i, s = Math.floor(s * i) / i
                }
                r = i
            }
            return t
        }, t
    }

    function Wn() {
        var t = On();
        return t.copy = function() {
            return Tn(t, Wn())
        }, At.apply(t, arguments), Zn(t)
    }

    function Kn(t) {
        return function(n) {
            return n < 0 ? -Math.pow(-n, t) : Math.pow(n, t)
        }
    }

    function Qn(t) {
        return t < 0 ? -Math.sqrt(-t) : Math.sqrt(t)
    }

    function Jn(t) {
        return t < 0 ? -t * t : t * t
    }

    function te(t) {
        var n = t(Sn, Sn),
            e = 1;

        function r() {
            return 1 === e ? t(Sn, Sn) : .5 === e ? t(Qn, Jn) : t(Kn(e), Kn(1 / e))
        }
        return n.exponent = function(t) {
            return arguments.length ? (e = +t, r()) : e
        }, Zn(n)
    }

    function ne() {
        var t = te(Pn());
        return t.copy = function() {
            return Tn(t, ne()).exponent(t.exponent())
        }, At.apply(t, arguments), t
    }

    function ee(t) {
        var n = 0,
            e = t.children,
            r = e && e.length;
        if (r)
            for (; --r >= 0;) n += e[r].value;
        else n = 1;
        t.value = n
    }

    function re(t, n) {
        t instanceof Map ? (t = [void 0, t], void 0 === n && (n = ae)) : void 0 === n && (n = ie);
        for (var e, r, i, a, o, u = new le(t), l = [u]; e = l.pop();)
            if ((i = n(e.data)) && (o = (i = Array.from(i)).length))
                for (e.children = i, a = o - 1; a >= 0; --a) l.push(r = i[a] = new le(i[a])), r.parent = e, r.depth = e.depth + 1;
        return u.eachBefore(ue)
    }

    function ie(t) {
        return t.children
    }

    function ae(t) {
        return Array.isArray(t) ? t[1] : null
    }

    function oe(t) {
        void 0 !== t.data.value && (t.value = t.data.value), t.data = t.data.data
    }

    function ue(t) {
        var n = 0;
        do {
            t.height = n
        } while ((t = t.parent) && t.height < ++n)
    }

    function le(t) {
        this.data = t, this.depth = this.height = 0, this.parent = null
    }

    function se(t) {
        t.x0 = Math.round(t.x0), t.y0 = Math.round(t.y0), t.x1 = Math.round(t.x1), t.y1 = Math.round(t.y1)
    }

    function ce() {
        var t = 1,
            n = 1,
            e = 0,
            r = !1;

        function i(i) {
            var a = i.height + 1;
            return i.x0 = i.y0 = e, i.x1 = t, i.y1 = n / a, i.eachBefore(function(t, n) {
                return function(r) {
                    r.children && function(t, n, e, r, i) {
                        for (var a, o = t.children, u = -1, l = o.length, s = t.value && (r - n) / t.value; ++u < l;)(a = o[u]).y0 = e, a.y1 = i, a.x0 = n, a.x1 = n += a.value * s
                    }(r, r.x0, t * (r.depth + 1) / n, r.x1, t * (r.depth + 2) / n);
                    var i = r.x0,
                        a = r.y0,
                        o = r.x1 - e,
                        u = r.y1 - e;
                    o < i && (i = o = (i + o) / 2), u < a && (a = u = (a + u) / 2), r.x0 = i, r.y0 = a, r.x1 = o, r.y1 = u
                }
            }(n, a)), r && i.eachBefore(se), i
        }
        return i.round = function(t) {
            return arguments.length ? (r = !!t, i) : r
        }, i.size = function(e) {
            return arguments.length ? (t = +e[0], n = +e[1], i) : [t, n]
        }, i.padding = function(t) {
            return arguments.length ? (e = +t, i) : e
        }, i
    }
    Hn = Fn({
        thousands: ",",
        grouping: [3],
        currency: ["$", ""]
    }), Un = Hn.format, $n = Hn.formatPrefix, le.prototype = re.prototype = {
        constructor: le,
        count: function() {
            return this.eachAfter(ee)
        },
        each: function(t, n) {
            let e = -1;
            for (const r of this) t.call(n, r, ++e, this);
            return this
        },
        eachAfter: function(t, n) {
            for (var e, r, i, a = this, o = [a], u = [], l = -1; a = o.pop();)
                if (u.push(a), e = a.children)
                    for (r = 0, i = e.length; r < i; ++r) o.push(e[r]);
            for (; a = u.pop();) t.call(n, a, ++l, this);
            return this
        },
        eachBefore: function(t, n) {
            for (var e, r, i = this, a = [i], o = -1; i = a.pop();)
                if (t.call(n, i, ++o, this), e = i.children)
                    for (r = e.length - 1; r >= 0; --r) a.push(e[r]);
            return this
        },
        find: function(t, n) {
            let e = -1;
            for (const r of this)
                if (t.call(n, r, ++e, this)) return r
        },
        sum: function(t) {
            return this.eachAfter((function(n) {
                for (var e = +t(n.data) || 0, r = n.children, i = r && r.length; --i >= 0;) e += r[i].value;
                n.value = e
            }))
        },
        sort: function(t) {
            return this.eachBefore((function(n) {
                n.children && n.children.sort(t)
            }))
        },
        path: function(t) {
            for (var n = this, e = function(t, n) {
                    if (t === n) return t;
                    var e = t.ancestors(),
                        r = n.ancestors(),
                        i = null;
                    t = e.pop(), n = r.pop();
                    for (; t === n;) i = t, t = e.pop(), n = r.pop();
                    return i
                }(n, t), r = [n]; n !== e;) n = n.parent, r.push(n);
            for (var i = r.length; t !== e;) r.splice(i, 0, t), t = t.parent;
            return r
        },
        ancestors: function() {
            for (var t = this, n = [t]; t = t.parent;) n.push(t);
            return n
        },
        descendants: function() {
            return Array.from(this)
        },
        leaves: function() {
            var t = [];
            return this.eachBefore((function(n) {
                n.children || t.push(n)
            })), t
        },
        links: function() {
            var t = this,
                n = [];
            return t.each((function(e) {
                e !== t && n.push({
                    source: e.parent,
                    target: e
                })
            })), n
        },
        copy: function() {
            return re(this).eachBefore(oe)
        },
        [Symbol.iterator]: function*() {
            var t, n, e, r, i = this,
                a = [i];
            do {
                for (t = a.reverse(), a = []; i = t.pop();)
                    if (yield i, n = i.children)
                        for (e = 0, r = n.length; e < r; ++e) a.push(n[e])
            } while (a.length)
        }
    };
    const fe = Math.PI,
        he = 2 * fe,
        pe = 1e-6,
        de = he - pe;

    function ye() {
        this._x0 = this._y0 = this._x1 = this._y1 = null, this._ = ""
    }

    function ve() {
        return new ye
    }

    function ge(t) {
        return function() {
            return t
        }
    }
    ye.prototype = ve.prototype = {
        constructor: ye,
        moveTo: function(t, n) {
            this._ += "M" + (this._x0 = this._x1 = +t) + "," + (this._y0 = this._y1 = +n)
        },
        closePath: function() {
            null !== this._x1 && (this._x1 = this._x0, this._y1 = this._y0, this._ += "Z")
        },
        lineTo: function(t, n) {
            this._ += "L" + (this._x1 = +t) + "," + (this._y1 = +n)
        },
        quadraticCurveTo: function(t, n, e, r) {
            this._ += "Q" + +t + "," + +n + "," + (this._x1 = +e) + "," + (this._y1 = +r)
        },
        bezierCurveTo: function(t, n, e, r, i, a) {
            this._ += "C" + +t + "," + +n + "," + +e + "," + +r + "," + (this._x1 = +i) + "," + (this._y1 = +a)
        },
        arcTo: function(t, n, e, r, i) {
            t = +t, n = +n, e = +e, r = +r, i = +i;
            var a = this._x1,
                o = this._y1,
                u = e - t,
                l = r - n,
                s = a - t,
                c = o - n,
                f = s * s + c * c;
            if (i < 0) throw new Error("negative radius: " + i);
            if (null === this._x1) this._ += "M" + (this._x1 = t) + "," + (this._y1 = n);
            else if (f > pe)
                if (Math.abs(c * u - l * s) > pe && i) {
                    var h = e - a,
                        p = r - o,
                        d = u * u + l * l,
                        y = h * h + p * p,
                        v = Math.sqrt(d),
                        g = Math.sqrt(f),
                        m = i * Math.tan((fe - Math.acos((d + f - y) / (2 * v * g))) / 2),
                        _ = m / g,
                        w = m / v;
                    Math.abs(_ - 1) > pe && (this._ += "L" + (t + _ * s) + "," + (n + _ * c)), this._ += "A" + i + "," + i + ",0,0," + +(c * h > s * p) + "," + (this._x1 = t + w * u) + "," + (this._y1 = n + w * l)
                } else this._ += "L" + (this._x1 = t) + "," + (this._y1 = n);
            else;
        },
        arc: function(t, n, e, r, i, a) {
            t = +t, n = +n, a = !!a;
            var o = (e = +e) * Math.cos(r),
                u = e * Math.sin(r),
                l = t + o,
                s = n + u,
                c = 1 ^ a,
                f = a ? r - i : i - r;
            if (e < 0) throw new Error("negative radius: " + e);
            null === this._x1 ? this._ += "M" + l + "," + s : (Math.abs(this._x1 - l) > pe || Math.abs(this._y1 - s) > pe) && (this._ += "L" + l + "," + s), e && (f < 0 && (f = f % he + he), f > de ? this._ += "A" + e + "," + e + ",0,1," + c + "," + (t - o) + "," + (n - u) + "A" + e + "," + e + ",0,1," + c + "," + (this._x1 = l) + "," + (this._y1 = s) : f > pe && (this._ += "A" + e + "," + e + ",0," + +(f >= fe) + "," + c + "," + (this._x1 = t + e * Math.cos(i)) + "," + (this._y1 = n + e * Math.sin(i))))
        },
        rect: function(t, n, e, r) {
            this._ += "M" + (this._x0 = this._x1 = +t) + "," + (this._y0 = this._y1 = +n) + "h" + +e + "v" + +r + "h" + -e + "Z"
        },
        toString: function() {
            return this._
        }
    };
    var me = Math.abs,
        _e = Math.atan2,
        we = Math.cos,
        xe = Math.max,
        be = Math.min,
        Me = Math.sin,
        Ae = Math.sqrt,
        Ne = 1e-12,
        Se = Math.PI,
        ke = Se / 2,
        Ee = 2 * Se;

    function Ce(t) {
        return t > 1 ? 0 : t < -1 ? Se : Math.acos(t)
    }

    function Te(t) {
        return t >= 1 ? ke : t <= -1 ? -ke : Math.asin(t)
    }

    function Pe(t) {
        return t.innerRadius
    }

    function Oe(t) {
        return t.outerRadius
    }

    function Re(t) {
        return t.startAngle
    }

    function Ie(t) {
        return t.endAngle
    }

    function je(t) {
        return t && t.padAngle
    }

    function qe(t, n, e, r, i, a, o, u) {
        var l = e - t,
            s = r - n,
            c = o - i,
            f = u - a,
            h = f * l - c * s;
        if (!(h * h < Ne)) return [t + (h = (c * (n - a) - f * (t - i)) / h) * l, n + h * s]
    }

    function Le(t, n, e, r, i, a, o) {
        var u = t - e,
            l = n - r,
            s = (o ? a : -a) / Ae(u * u + l * l),
            c = s * l,
            f = -s * u,
            h = t + c,
            p = n + f,
            d = e + c,
            y = r + f,
            v = (h + d) / 2,
            g = (p + y) / 2,
            m = d - h,
            _ = y - p,
            w = m * m + _ * _,
            x = i - a,
            b = h * y - d * p,
            M = (_ < 0 ? -1 : 1) * Ae(xe(0, x * x * w - b * b)),
            A = (b * _ - m * M) / w,
            N = (-b * m - _ * M) / w,
            S = (b * _ + m * M) / w,
            k = (-b * m + _ * M) / w,
            E = A - v,
            C = N - g,
            T = S - v,
            P = k - g;
        return E * E + C * C > T * T + P * P && (A = S, N = k), {
            cx: A,
            cy: N,
            x01: -c,
            y01: -f,
            x11: A * (i / x - 1),
            y11: N * (i / x - 1)
        }
    }
    var ze = {
        value: () => {}
    };

    function De() {
        for (var t, n = 0, e = arguments.length, r = {}; n < e; ++n) {
            if (!(t = arguments[n] + "") || t in r || /[\s.]/.test(t)) throw new Error("illegal type: " + t);
            r[t] = []
        }
        return new Be(r)
    }

    function Be(t) {
        this._ = t
    }

    function Xe(t, n) {
        return t.trim().split(/^|\s+/).map((function(t) {
            var e = "",
                r = t.indexOf(".");
            if (r >= 0 && (e = t.slice(r + 1), t = t.slice(0, r)), t && !n.hasOwnProperty(t)) throw new Error("unknown type: " + t);
            return {
                type: t,
                name: e
            }
        }))
    }

    function He(t, n) {
        for (var e, r = 0, i = t.length; r < i; ++r)
            if ((e = t[r]).name === n) return e.value
    }

    function Ue(t, n, e) {
        for (var r = 0, i = t.length; r < i; ++r)
            if (t[r].name === n) {
                t[r] = ze, t = t.slice(0, r).concat(t.slice(r + 1));
                break
            } return null != e && t.push({
            name: n,
            value: e
        }), t
    }
    Be.prototype = De.prototype = {
        constructor: Be,
        on: function(t, n) {
            var e, r = this._,
                i = Xe(t + "", r),
                a = -1,
                o = i.length;
            if (!(arguments.length < 2)) {
                if (null != n && "function" != typeof n) throw new Error("invalid callback: " + n);
                for (; ++a < o;)
                    if (e = (t = i[a]).type) r[e] = Ue(r[e], t.name, n);
                    else if (null == n)
                    for (e in r) r[e] = Ue(r[e], t.name, null);
                return this
            }
            for (; ++a < o;)
                if ((e = (t = i[a]).type) && (e = He(r[e], t.name))) return e
        },
        copy: function() {
            var t = {},
                n = this._;
            for (var e in n) t[e] = n[e].slice();
            return new Be(t)
        },
        call: function(t, n) {
            if ((e = arguments.length - 2) > 0)
                for (var e, r, i = new Array(e), a = 0; a < e; ++a) i[a] = arguments[a + 2];
            if (!this._.hasOwnProperty(t)) throw new Error("unknown type: " + t);
            for (a = 0, e = (r = this._[t]).length; a < e; ++a) r[a].value.apply(n, i)
        },
        apply: function(t, n, e) {
            if (!this._.hasOwnProperty(t)) throw new Error("unknown type: " + t);
            for (var r = this._[t], i = 0, a = r.length; i < a; ++i) r[i].value.apply(n, e)
        }
    };
    var $e, Ve, Ye = 0,
        Fe = 0,
        Ge = 0,
        Ze = 0,
        We = 0,
        Ke = 0,
        Qe = "object" == typeof performance && performance.now ? performance : Date,
        Je = "object" == typeof window && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(t) {
            setTimeout(t, 17)
        };

    function tr() {
        return We || (Je(nr), We = Qe.now() + Ke)
    }

    function nr() {
        We = 0
    }

    function er() {
        this._call = this._time = this._next = null
    }

    function rr(t, n, e) {
        var r = new er;
        return r.restart(t, n, e), r
    }

    function ir() {
        We = (Ze = Qe.now()) + Ke, Ye = Fe = 0;
        try {
            ! function() {
                tr(), ++Ye;
                for (var t, n = $e; n;)(t = We - n._time) >= 0 && n._call.call(void 0, t), n = n._next;
                --Ye
            }()
        } finally {
            Ye = 0,
                function() {
                    var t, n, e = $e,
                        r = 1 / 0;
                    for (; e;) e._call ? (r > e._time && (r = e._time), t = e, e = e._next) : (n = e._next, e._next = null, e = t ? t._next = n : $e = n);
                    Ve = t, or(r)
                }(), We = 0
        }
    }

    function ar() {
        var t = Qe.now(),
            n = t - Ze;
        n > 1e3 && (Ke -= n, Ze = t)
    }

    function or(t) {
        Ye || (Fe && (Fe = clearTimeout(Fe)), t - We > 24 ? (t < 1 / 0 && (Fe = setTimeout(ir, t - Qe.now() - Ke)), Ge && (Ge = clearInterval(Ge))) : (Ge || (Ze = Qe.now(), Ge = setInterval(ar, 1e3)), Ye = 1, Je(ir)))
    }

    function ur(t, n, e) {
        var r = new er;
        return n = null == n ? 0 : +n, r.restart((e => {
            r.stop(), t(e + n)
        }), n, e), r
    }
    er.prototype = rr.prototype = {
        constructor: er,
        restart: function(t, n, e) {
            if ("function" != typeof t) throw new TypeError("callback is not a function");
            e = (null == e ? tr() : +e) + (null == n ? 0 : +n), this._next || Ve === this || (Ve ? Ve._next = this : $e = this, Ve = this), this._call = t, this._time = e, or()
        },
        stop: function() {
            this._call && (this._call = null, this._time = 1 / 0, or())
        }
    };
    var lr = De("start", "end", "cancel", "interrupt"),
        sr = [];

    function cr(t, n, e, r, i, a) {
        var o = t.__transition;
        if (o) {
            if (e in o) return
        } else t.__transition = {};
        ! function(t, n, e) {
            var r, i = t.__transition;

            function a(t) {
                e.state = 1, e.timer.restart(o, e.delay, e.time), e.delay <= t && o(t - e.delay)
            }

            function o(a) {
                var s, c, f, h;
                if (1 !== e.state) return l();
                for (s in i)
                    if ((h = i[s]).name === e.name) {
                        if (3 === h.state) return ur(o);
                        4 === h.state ? (h.state = 6, h.timer.stop(), h.on.call("interrupt", t, t.__data__, h.index, h.group), delete i[s]) : +s < n && (h.state = 6, h.timer.stop(), h.on.call("cancel", t, t.__data__, h.index, h.group), delete i[s])
                    } if (ur((function() {
                        3 === e.state && (e.state = 4, e.timer.restart(u, e.delay, e.time), u(a))
                    })), e.state = 2, e.on.call("start", t, t.__data__, e.index, e.group), 2 === e.state) {
                    for (e.state = 3, r = new Array(f = e.tween.length), s = 0, c = -1; s < f; ++s)(h = e.tween[s].value.call(t, t.__data__, e.index, e.group)) && (r[++c] = h);
                    r.length = c + 1
                }
            }

            function u(n) {
                for (var i = n < e.duration ? e.ease.call(null, n / e.duration) : (e.timer.restart(l), e.state = 5, 1), a = -1, o = r.length; ++a < o;) r[a].call(t, i);
                5 === e.state && (e.on.call("end", t, t.__data__, e.index, e.group), l())
            }

            function l() {
                for (var r in e.state = 6, e.timer.stop(), delete i[n], i) return;
                delete t.__transition
            }
            i[n] = e, e.timer = rr(a, 0, e.time)
        }(t, e, {
            name: n,
            index: r,
            group: i,
            on: lr,
            tween: sr,
            time: a.time,
            delay: a.delay,
            duration: a.duration,
            ease: a.ease,
            timer: null,
            state: 0
        })
    }

    function fr(t, n) {
        var e = pr(t, n);
        if (e.state > 0) throw new Error("too late; already scheduled");
        return e
    }

    function hr(t, n) {
        var e = pr(t, n);
        if (e.state > 3) throw new Error("too late; already running");
        return e
    }

    function pr(t, n) {
        var e = t.__transition;
        if (!e || !(e = e[n])) throw new Error("transition not found");
        return e
    }

    function dr(t, n) {
        var e, r;
        return function() {
            var i = hr(this, t),
                a = i.tween;
            if (a !== e)
                for (var o = 0, u = (r = e = a).length; o < u; ++o)
                    if (r[o].name === n) {
                        (r = r.slice()).splice(o, 1);
                        break
                    } i.tween = r
        }
    }

    function yr(t, n, e) {
        var r, i;
        if ("function" != typeof e) throw new Error;
        return function() {
            var a = hr(this, t),
                o = a.tween;
            if (o !== r) {
                i = (r = o).slice();
                for (var u = {
                        name: n,
                        value: e
                    }, l = 0, s = i.length; l < s; ++l)
                    if (i[l].name === n) {
                        i[l] = u;
                        break
                    } l === s && i.push(u)
            }
            a.tween = i
        }
    }

    function vr(t, n, e) {
        var r = t._id;
        return t.each((function() {
                var t = hr(this, r);
                (t.value || (t.value = {}))[n] = e.apply(this, arguments)
            })),
            function(t) {
                return pr(t, r).value[n]
            }
    }

    function gr(t, n) {
        var e;
        return ("number" == typeof n ? cn : n instanceof Ut ? on : (e = Ut(n)) ? (n = e, on) : dn)(t, n)
    }

    function mr(t) {
        return function() {
            this.removeAttribute(t)
        }
    }

    function _r(t) {
        return function() {
            this.removeAttributeNS(t.space, t.local)
        }
    }

    function wr(t, n, e) {
        var r, i, a = e + "";
        return function() {
            var o = this.getAttribute(t);
            return o === a ? null : o === r ? i : i = n(r = o, e)
        }
    }

    function xr(t, n, e) {
        var r, i, a = e + "";
        return function() {
            var o = this.getAttributeNS(t.space, t.local);
            return o === a ? null : o === r ? i : i = n(r = o, e)
        }
    }

    function br(t, n, e) {
        var r, i, a;
        return function() {
            var o, u, l = e(this);
            if (null != l) return (o = this.getAttribute(t)) === (u = l + "") ? null : o === r && u === i ? a : (i = u, a = n(r = o, l));
            this.removeAttribute(t)
        }
    }

    function Mr(t, n, e) {
        var r, i, a;
        return function() {
            var o, u, l = e(this);
            if (null != l) return (o = this.getAttributeNS(t.space, t.local)) === (u = l + "") ? null : o === r && u === i ? a : (i = u, a = n(r = o, l));
            this.removeAttributeNS(t.space, t.local)
        }
    }

    function Ar(t, n) {
        return function(e) {
            this.setAttribute(t, n.call(this, e))
        }
    }

    function Nr(t, n) {
        return function(e) {
            this.setAttributeNS(t.space, t.local, n.call(this, e))
        }
    }

    function Sr(t, n) {
        var e, r;

        function i() {
            var i = n.apply(this, arguments);
            return i !== r && (e = (r = i) && Nr(t, i)), e
        }
        return i._value = n, i
    }

    function kr(t, n) {
        var e, r;

        function i() {
            var i = n.apply(this, arguments);
            return i !== r && (e = (r = i) && Ar(t, i)), e
        }
        return i._value = n, i
    }

    function Er(t, n) {
        return function() {
            fr(this, t).delay = +n.apply(this, arguments)
        }
    }

    function Cr(t, n) {
        return n = +n,
            function() {
                fr(this, t).delay = n
            }
    }

    function Tr(t, n) {
        return function() {
            hr(this, t).duration = +n.apply(this, arguments)
        }
    }

    function Pr(t, n) {
        return n = +n,
            function() {
                hr(this, t).duration = n
            }
    }

    function Or(t, n) {
        if ("function" != typeof n) throw new Error;
        return function() {
            hr(this, t).ease = n
        }
    }

    function Rr(t, n, e) {
        var r, i, a = function(t) {
            return (t + "").trim().split(/^|\s+/).every((function(t) {
                var n = t.indexOf(".");
                return n >= 0 && (t = t.slice(0, n)), !t || "start" === t
            }))
        }(n) ? fr : hr;
        return function() {
            var o = a(this, t),
                u = o.on;
            u !== r && (i = (r = u).copy()).on(n, e), o.on = i
        }
    }
    var Ir = yt.prototype.constructor;

    function jr(t) {
        return function() {
            this.style.removeProperty(t)
        }
    }

    function qr(t, n, e) {
        return function(r) {
            this.style.setProperty(t, n.call(this, r), e)
        }
    }

    function Lr(t, n, e) {
        var r, i;

        function a() {
            var a = n.apply(this, arguments);
            return a !== i && (r = (i = a) && qr(t, a, e)), r
        }
        return a._value = n, a
    }

    function zr(t) {
        return function(n) {
            this.textContent = t.call(this, n)
        }
    }

    function Dr(t) {
        var n, e;

        function r() {
            var r = t.apply(this, arguments);
            return r !== e && (n = (e = r) && zr(r)), n
        }
        return r._value = t, r
    }
    var Br = 0;

    function Xr(t, n, e, r) {
        this._groups = t, this._parents = n, this._name = e, this._id = r
    }

    function Hr(t) {
        return yt().transition(t)
    }

    function Ur() {
        return ++Br
    }
    var $r = yt.prototype;
    Xr.prototype = Hr.prototype = {
        constructor: Xr,
        select: function(t) {
            var n = this._name,
                e = this._id;
            "function" != typeof t && (t = s(t));
            for (var r = this._groups, i = r.length, a = new Array(i), o = 0; o < i; ++o)
                for (var u, l, c = r[o], f = c.length, h = a[o] = new Array(f), p = 0; p < f; ++p)(u = c[p]) && (l = t.call(u, u.__data__, p, c)) && ("__data__" in u && (l.__data__ = u.__data__), h[p] = l, cr(h[p], n, e, p, h, pr(u, e)));
            return new Xr(a, this._parents, n, e)
        },
        selectAll: function(t) {
            var n = this._name,
                e = this._id;
            "function" != typeof t && (t = h(t));
            for (var r = this._groups, i = r.length, a = [], o = [], u = 0; u < i; ++u)
                for (var l, s = r[u], c = s.length, f = 0; f < c; ++f)
                    if (l = s[f]) {
                        for (var p, d = t.call(l, l.__data__, f, s), y = pr(l, e), v = 0, g = d.length; v < g; ++v)(p = d[v]) && cr(p, n, e, v, d, y);
                        a.push(d), o.push(l)
                    } return new Xr(a, o, n, e)
        },
        selectChild: $r.selectChild,
        selectChildren: $r.selectChildren,
        filter: function(t) {
            "function" != typeof t && (t = p(t));
            for (var n = this._groups, e = n.length, r = new Array(e), i = 0; i < e; ++i)
                for (var a, o = n[i], u = o.length, l = r[i] = [], s = 0; s < u; ++s)(a = o[s]) && t.call(a, a.__data__, s, o) && l.push(a);
            return new Xr(r, this._parents, this._name, this._id)
        },
        merge: function(t) {
            if (t._id !== this._id) throw new Error;
            for (var n = this._groups, e = t._groups, r = n.length, i = e.length, a = Math.min(r, i), o = new Array(r), u = 0; u < a; ++u)
                for (var l, s = n[u], c = e[u], f = s.length, h = o[u] = new Array(f), p = 0; p < f; ++p)(l = s[p] || c[p]) && (h[p] = l);
            for (; u < r; ++u) o[u] = n[u];
            return new Xr(o, this._parents, this._name, this._id)
        },
        selection: function() {
            return new Ir(this._groups, this._parents)
        },
        transition: function() {
            for (var t = this._name, n = this._id, e = Ur(), r = this._groups, i = r.length, a = 0; a < i; ++a)
                for (var o, u = r[a], l = u.length, s = 0; s < l; ++s)
                    if (o = u[s]) {
                        var c = pr(o, n);
                        cr(o, t, e, s, u, {
                            time: c.time + c.delay + c.duration,
                            delay: 0,
                            duration: c.duration,
                            ease: c.ease
                        })
                    } return new Xr(r, this._parents, t, e)
        },
        call: $r.call,
        nodes: $r.nodes,
        node: $r.node,
        size: $r.size,
        empty: $r.empty,
        each: $r.each,
        on: function(t, n) {
            var e = this._id;
            return arguments.length < 2 ? pr(this.node(), e).on.on(t) : this.each(Rr(e, t, n))
        },
        attr: function(t, n) {
            var e = i(t),
                r = "transform" === e ? Mn : gr;
            return this.attrTween(t, "function" == typeof n ? (e.local ? Mr : br)(e, r, vr(this, "attr." + t, n)) : null == n ? (e.local ? _r : mr)(e) : (e.local ? xr : wr)(e, r, n))
        },
        attrTween: function(t, n) {
            var e = "attr." + t;
            if (arguments.length < 2) return (e = this.tween(e)) && e._value;
            if (null == n) return this.tween(e, null);
            if ("function" != typeof n) throw new Error;
            var r = i(t);
            return this.tween(e, (r.local ? Sr : kr)(r, n))
        },
        style: function(t, n, e) {
            var r = "transform" == (t += "") ? bn : gr;
            return null == n ? this.styleTween(t, function(t, n) {
                var e, r, i;
                return function() {
                    var a = L(this, t),
                        o = (this.style.removeProperty(t), L(this, t));
                    return a === o ? null : a === e && o === r ? i : i = n(e = a, r = o)
                }
            }(t, r)).on("end.style." + t, jr(t)) : "function" == typeof n ? this.styleTween(t, function(t, n, e) {
                var r, i, a;
                return function() {
                    var o = L(this, t),
                        u = e(this),
                        l = u + "";
                    return null == u && (this.style.removeProperty(t), l = u = L(this, t)), o === l ? null : o === r && l === i ? a : (i = l, a = n(r = o, u))
                }
            }(t, r, vr(this, "style." + t, n))).each(function(t, n) {
                var e, r, i, a, o = "style." + n,
                    u = "end." + o;
                return function() {
                    var l = hr(this, t),
                        s = l.on,
                        c = null == l.value[o] ? a || (a = jr(n)) : void 0;
                    s === e && i === c || (r = (e = s).copy()).on(u, i = c), l.on = r
                }
            }(this._id, t)) : this.styleTween(t, function(t, n, e) {
                var r, i, a = e + "";
                return function() {
                    var o = L(this, t);
                    return o === a ? null : o === r ? i : i = n(r = o, e)
                }
            }(t, r, n), e).on("end.style." + t, null)
        },
        styleTween: function(t, n, e) {
            var r = "style." + (t += "");
            if (arguments.length < 2) return (r = this.tween(r)) && r._value;
            if (null == n) return this.tween(r, null);
            if ("function" != typeof n) throw new Error;
            return this.tween(r, Lr(t, n, null == e ? "" : e))
        },
        text: function(t) {
            return this.tween("text", "function" == typeof t ? function(t) {
                return function() {
                    var n = t(this);
                    this.textContent = null == n ? "" : n
                }
            }(vr(this, "text", t)) : function(t) {
                return function() {
                    this.textContent = t
                }
            }(null == t ? "" : t + ""))
        },
        textTween: function(t) {
            var n = "text";
            if (arguments.length < 1) return (n = this.tween(n)) && n._value;
            if (null == t) return this.tween(n, null);
            if ("function" != typeof t) throw new Error;
            return this.tween(n, Dr(t))
        },
        remove: function() {
            return this.on("end.remove", function(t) {
                return function() {
                    var n = this.parentNode;
                    for (var e in this.__transition)
                        if (+e !== t) return;
                    n && n.removeChild(this)
                }
            }(this._id))
        },
        tween: function(t, n) {
            var e = this._id;
            if (t += "", arguments.length < 2) {
                for (var r, i = pr(this.node(), e).tween, a = 0, o = i.length; a < o; ++a)
                    if ((r = i[a]).name === t) return r.value;
                return null
            }
            return this.each((null == n ? dr : yr)(e, t, n))
        },
        delay: function(t) {
            var n = this._id;
            return arguments.length ? this.each(("function" == typeof t ? Er : Cr)(n, t)) : pr(this.node(), n).delay
        },
        duration: function(t) {
            var n = this._id;
            return arguments.length ? this.each(("function" == typeof t ? Tr : Pr)(n, t)) : pr(this.node(), n).duration
        },
        ease: function(t) {
            var n = this._id;
            return arguments.length ? this.each(Or(n, t)) : pr(this.node(), n).ease
        },
        easeVarying: function(t) {
            if ("function" != typeof t) throw new Error;
            return this.each(function(t, n) {
                return function() {
                    var e = n.apply(this, arguments);
                    if ("function" != typeof e) throw new Error;
                    hr(this, t).ease = e
                }
            }(this._id, t))
        },
        end: function() {
            var t, n, e = this,
                r = e._id,
                i = e.size();
            return new Promise((function(a, o) {
                var u = {
                        value: o
                    },
                    l = {
                        value: function() {
                            0 == --i && a()
                        }
                    };
                e.each((function() {
                    var e = hr(this, r),
                        i = e.on;
                    i !== t && ((n = (t = i).copy())._.cancel.push(u), n._.interrupt.push(u), n._.end.push(l)), e.on = n
                })), 0 === i && a()
            }))
        },
        [Symbol.iterator]: $r[Symbol.iterator]
    };
    var Vr = {
        time: null,
        delay: 0,
        duration: 250,
        ease: function(t) {
            return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2
        }
    };

    function Yr(t, n) {
        for (var e; !(e = t.__transition) || !(e = e[n]);)
            if (!(t = t.parentNode)) throw new Error(`transition ${n} not found`);
        return e
    }

    function Fr(t, n, e) {
        var r, i, a, o, u;

        function l() {
            var s = Date.now() - o;
            s < n && s >= 0 ? r = setTimeout(l, n - s) : (r = null, e || (u = t.apply(a, i), a = i = null))
        }
        null == n && (n = 100);
        var s = function() {
            a = this, i = arguments, o = Date.now();
            var s = e && !r;
            return r || (r = setTimeout(l, n)), s && (u = t.apply(a, i), a = i = null), u
        };
        return s.clear = function() {
            r && (clearTimeout(r), r = null)
        }, s.flush = function() {
            r && (u = t.apply(a, i), a = i = null, clearTimeout(r), r = null)
        }, s
    }
    yt.prototype.interrupt = function(t) {
        return this.each((function() {
            ! function(t, n) {
                var e, r, i, a = t.__transition,
                    o = !0;
                if (a) {
                    for (i in n = null == n ? null : n + "", a)(e = a[i]).name === n ? (r = e.state > 2 && e.state < 5, e.state = 6, e.timer.stop(), e.on.call(r ? "interrupt" : "cancel", t, t.__data__, e.index, e.group), delete a[i]) : o = !1;
                    o && delete t.__transition
                }
            }(this, t)
        }))
    }, yt.prototype.transition = function(t) {
        var n, e;
        t instanceof Xr ? (n = t._id, t = t._name) : (n = Ur(), (e = Vr).time = tr(), t = null == t ? null : t + "");
        for (var r = this._groups, i = r.length, a = 0; a < i; ++a)
            for (var o, u = r[a], l = u.length, s = 0; s < l; ++s)(o = u[s]) && cr(o, t, n, s, u, e || Yr(o, n));
        return new Xr(r, this._parents, t, n)
    }, Fr.debounce = Fr;
    var Gr = Fr;

    function Zr(t, n) {
        return function(t) {
            if (Array.isArray(t)) return t
        }(t) || function(t, n) {
            var e = t && ("undefined" != typeof Symbol && t[Symbol.iterator] || t["@@iterator"]);
            if (null == e) return;
            var r, i, a = [],
                o = !0,
                u = !1;
            try {
                for (e = e.call(t); !(o = (r = e.next()).done) && (a.push(r.value), !n || a.length !== n); o = !0);
            } catch (t) {
                u = !0, i = t
            } finally {
                try {
                    o || null == e.return || e.return()
                } finally {
                    if (u) throw i
                }
            }
            return a
        }(t, n) || function(t, n) {
            if (!t) return;
            if ("string" == typeof t) return Wr(t, n);
            var e = Object.prototype.toString.call(t).slice(8, -1);
            "Object" === e && t.constructor && (e = t.constructor.name);
            if ("Map" === e || "Set" === e) return Array.from(t);
            if ("Arguments" === e || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e)) return Wr(t, n)
        }(t, n) || function() {
            throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
        }()
    }

    function Wr(t, n) {
        (null == n || n > t.length) && (n = t.length);
        for (var e = 0, r = new Array(n); e < n; e++) r[e] = t[e];
        return r
    }
    var Kr = function t(n, e) {
        var r = e.default,
            i = void 0 === r ? null : r,
            a = e.triggerUpdate,
            o = void 0 === a || a,
            u = e.onChange,
            l = void 0 === u ? function(t, n) {} : u;
        ! function(t, n) {
            if (!(t instanceof n)) throw new TypeError("Cannot call a class as a function")
        }(this, t), this.name = n, this.defaultVal = i, this.triggerUpdate = o, this.onChange = l
    };
    var Qr, Jr, ti, ni, ei, ri, ii, ai, oi, ui, li, si, ci, fi, hi = function(t) {
        return t instanceof Function ? t : "string" == typeof t ? function(n) {
            return n[t]
        } : function(n) {
            return t
        }
    };
    return Qr = {
            props: {
                width: {
                    default: window.innerWidth
                },
                height: {
                    default: window.innerHeight
                },
                data: {
                    onChange: function(t, n) {
                        n.needsReparse = !0
                    }
                },
                children: {
                    default: "children",
                    onChange: function(t, n) {
                        n.needsReparse = !0
                    }
                },
                sort: {
                    onChange: function(t, n) {
                        n.needsReparse = !0
                    }
                },
                label: {
                    default: function(t) {
                        return t.name
                    }
                },
                labelOrientation: {
                    default: "auto"
                },
                size: {
                    default: "value",
                    onChange: function(t, n) {
                        n.needsReparse = !0
                    }
                },
                color: {
                    default: function(t) {
                        return "lightgrey"
                    }
                },
                strokeColor: {
                    default: function(t) {
                        return "white"
                    }
                },
                nodeClassName: {},
                minSliceAngle: {
                    default: .2
                },
                maxLevels: {},
                excludeRoot: {
                    default: !1,
                    onChange: function(t, n) {
                        n.needsReparse = !0
                    }
                },
                centerRadius: {
                    default: .1
                },
                radiusScaleExponent: {
                    default: .5
                },
                showLabels: {
                    default: !0
                },
                tooltipContent: {
                    default: function(t) {
                        return ""
                    },
                    triggerUpdate: !1
                },
                tooltipTitle: {
                    default: null,
                    triggerUpdate: !1
                },
                showTooltip: {
                    default: function(t) {
                        return !0
                    },
                    triggerUpdate: !1
                },
                focusOnNode: {
                    onChange: function(t, n) {
                        t && n.initialised && function t(e) {
                            n.svg.selectAll(".slice").filter((function(t) {
                                return t === e
                            })).each((function(n) {
                                this.parentNode.appendChild(this), n.parent && t(n.parent)
                            }))
                        }(t.__dataNode)
                    }
                },
                onClick: {
                    triggerUpdate: !1
                },
                onHover: {
                    triggerUpdate: !1
                },
                transitionDuration: {
                    default: 750,
                    triggerUpdate: !1
                }
            },
            methods: {
                _parseData: function(t) {
                    if (t.data) {
                        var n = re(t.data, hi(t.children)).sum(hi(t.size));
                        if (t.sort && n.sort(t.sort), ce().padding(0)(n), t.excludeRoot) {
                            var e = Wn().domain([n.y1 - n.y0, 1]);
                            n.descendants().forEach((function(t) {
                                t.y0 = e(t.y0), t.y1 = e(t.y1)
                            }))
                        }
                        n.descendants().forEach((function(t, n) {
                            t.id = n, t.data.__dataNode = t
                        })), t.layoutData = n.descendants()
                    }
                }
            },
            aliases: {
                onNodeClick: "onClick"
            },
            init: function(t, n) {
                var e = this;
                n.chartId = Math.round(1e12 * Math.random()), n.radiusScale = ne(), n.angleScale = Wn().domain([0, 10]).range([0, 2 * Math.PI]).clamp(!0), n.arc = function() {
                    var t = Pe,
                        n = Oe,
                        e = ge(0),
                        r = null,
                        i = Re,
                        a = Ie,
                        o = je,
                        u = null;

                    function l() {
                        var l, s, c = +t.apply(this, arguments),
                            f = +n.apply(this, arguments),
                            h = i.apply(this, arguments) - ke,
                            p = a.apply(this, arguments) - ke,
                            d = me(p - h),
                            y = p > h;
                        if (u || (u = l = ve()), f < c && (s = f, f = c, c = s), f > Ne)
                            if (d > Ee - Ne) u.moveTo(f * we(h), f * Me(h)), u.arc(0, 0, f, h, p, !y), c > Ne && (u.moveTo(c * we(p), c * Me(p)), u.arc(0, 0, c, p, h, y));
                            else {
                                var v, g, m = h,
                                    _ = p,
                                    w = h,
                                    x = p,
                                    b = d,
                                    M = d,
                                    A = o.apply(this, arguments) / 2,
                                    N = A > Ne && (r ? +r.apply(this, arguments) : Ae(c * c + f * f)),
                                    S = be(me(f - c) / 2, +e.apply(this, arguments)),
                                    k = S,
                                    E = S;
                                if (N > Ne) {
                                    var C = Te(N / c * Me(A)),
                                        T = Te(N / f * Me(A));
                                    (b -= 2 * C) > Ne ? (w += C *= y ? 1 : -1, x -= C) : (b = 0, w = x = (h + p) / 2), (M -= 2 * T) > Ne ? (m += T *= y ? 1 : -1, _ -= T) : (M = 0, m = _ = (h + p) / 2)
                                }
                                var P = f * we(m),
                                    O = f * Me(m),
                                    R = c * we(x),
                                    I = c * Me(x);
                                if (S > Ne) {
                                    var j, q = f * we(_),
                                        L = f * Me(_),
                                        z = c * we(w),
                                        D = c * Me(w);
                                    if (d < Se && (j = qe(P, O, z, D, q, L, R, I))) {
                                        var B = P - j[0],
                                            X = O - j[1],
                                            H = q - j[0],
                                            U = L - j[1],
                                            $ = 1 / Me(Ce((B * H + X * U) / (Ae(B * B + X * X) * Ae(H * H + U * U))) / 2),
                                            V = Ae(j[0] * j[0] + j[1] * j[1]);
                                        k = be(S, (c - V) / ($ - 1)), E = be(S, (f - V) / ($ + 1))
                                    }
                                }
                                M > Ne ? E > Ne ? (v = Le(z, D, P, O, f, E, y), g = Le(q, L, R, I, f, E, y), u.moveTo(v.cx + v.x01, v.cy + v.y01), E < S ? u.arc(v.cx, v.cy, E, _e(v.y01, v.x01), _e(g.y01, g.x01), !y) : (u.arc(v.cx, v.cy, E, _e(v.y01, v.x01), _e(v.y11, v.x11), !y), u.arc(0, 0, f, _e(v.cy + v.y11, v.cx + v.x11), _e(g.cy + g.y11, g.cx + g.x11), !y), u.arc(g.cx, g.cy, E, _e(g.y11, g.x11), _e(g.y01, g.x01), !y))) : (u.moveTo(P, O), u.arc(0, 0, f, m, _, !y)) : u.moveTo(P, O), c > Ne && b > Ne ? k > Ne ? (v = Le(R, I, q, L, c, -k, y), g = Le(P, O, z, D, c, -k, y), u.lineTo(v.cx + v.x01, v.cy + v.y01), k < S ? u.arc(v.cx, v.cy, k, _e(v.y01, v.x01), _e(g.y01, g.x01), !y) : (u.arc(v.cx, v.cy, k, _e(v.y01, v.x01), _e(v.y11, v.x11), !y), u.arc(0, 0, c, _e(v.cy + v.y11, v.cx + v.x11), _e(g.cy + g.y11, g.cx + g.x11), y), u.arc(g.cx, g.cy, k, _e(g.y11, g.x11), _e(g.y01, g.x01), !y))) : u.arc(0, 0, c, x, w, y) : u.lineTo(R, I)
                            }
                        else u.moveTo(0, 0);
                        if (u.closePath(), l) return u = null, l + "" || null
                    }
                    return l.centroid = function() {
                        var e = (+t.apply(this, arguments) + +n.apply(this, arguments)) / 2,
                            r = (+i.apply(this, arguments) + +a.apply(this, arguments)) / 2 - Se / 2;
                        return [we(r) * e, Me(r) * e]
                    }, l.innerRadius = function(n) {
                        return arguments.length ? (t = "function" == typeof n ? n : ge(+n), l) : t
                    }, l.outerRadius = function(t) {
                        return arguments.length ? (n = "function" == typeof t ? t : ge(+t), l) : n
                    }, l.cornerRadius = function(t) {
                        return arguments.length ? (e = "function" == typeof t ? t : ge(+t), l) : e
                    }, l.padRadius = function(t) {
                        return arguments.length ? (r = null == t ? null : "function" == typeof t ? t : ge(+t), l) : r
                    }, l.startAngle = function(t) {
                        return arguments.length ? (i = "function" == typeof t ? t : ge(+t), l) : i
                    }, l.endAngle = function(t) {
                        return arguments.length ? (a = "function" == typeof t ? t : ge(+t), l) : a
                    }, l.padAngle = function(t) {
                        return arguments.length ? (o = "function" == typeof t ? t : ge(+t), l) : o
                    }, l.context = function(t) {
                        return arguments.length ? (u = null == t ? null : t, l) : u
                    }, l
                }().startAngle((function(t) {
                    return n.angleScale(t.x0)
                })).endAngle((function(t) {
                    return n.angleScale(t.x1)
                })).innerRadius((function(t) {
                    return Math.max(0, n.radiusScale(t.y0))
                })).outerRadius((function(t) {
                    return Math.max(0, n.radiusScale(t.y1))
                }));
                var r = function(t) {
                    return "string" == typeof t ? new dt([
                        [document.querySelector(t)]
                    ], [document.documentElement]) : new dt([
                        [t]
                    ], pt)
                }(t).append("div").attr("class", "sunburst-viz");
                n.svg = r.append("svg"), n.canvas = n.svg.append("g"), n.tooltip = r.append("div").attr("class", "sunburst-tooltip"), r.on("mousemove", (function(t) {
                    var e = function(t, n) {
                        if (t = function(t) {
                                let n;
                                for (; n = t.sourceEvent;) t = n;
                                return t
                            }(t), void 0 === n && (n = t.currentTarget), n) {
                            var e = n.ownerSVGElement || n;
                            if (e.createSVGPoint) {
                                var r = e.createSVGPoint();
                                return r.x = t.clientX, r.y = t.clientY, [(r = r.matrixTransform(n.getScreenCTM().inverse())).x, r.y]
                            }
                            if (n.getBoundingClientRect) {
                                var i = n.getBoundingClientRect();
                                return [t.clientX - i.left - n.clientLeft, t.clientY - i.top - n.clientTop]
                            }
                        }
                        return [t.pageX, t.pageY]
                    }(t);
                    n.tooltip.style("left", e[0] + "px").style("top", e[1] + "px").style("transform", "translate(-".concat(e[0] / n.width * 100, "%, 21px)"))
                })), n.svg.on("click", (function() {
                    return (n.onClick || e.focusOnNode)(null)
                })).on("mouseover", (function() {
                    return n.onHover && n.onHover(null)
                }))
            },
            update: function(n) {
                var e = this;
                n.needsReparse && (this._parseData(), n.needsReparse = !1);
                var r = Math.min(n.width, n.height) / 2;
                if (n.radiusScale.range([r * Math.max(0, Math.min(1, n.centerRadius)), r]), n.radiusScaleExponent > 0 && n.radiusScale.exponent(n.radiusScaleExponent), n.svg.style("width", n.width + "px").style("height", n.height + "px").attr("viewBox", "".concat(-n.width / 2, " ").concat(-n.height / 2, " ").concat(n.width, " ").concat(n.height)), n.layoutData) {
                    var i = n.focusOnNode && n.focusOnNode.__dataNode.y0 >= 0 && n.focusOnNode.__dataNode || {
                            x0: 0,
                            x1: 1,
                            y0: 0,
                            y1: 1
                        },
                        a = n.canvas.selectAll(".slice").data(n.layoutData.filter((function(t) {
                            return t.x1 >= i.x0 && t.x0 <= i.x1 && (t.x1 - t.x0) / (i.x1 - i.x0) > n.minSliceAngle / 360 && (!n.maxLevels || t.depth - (i.depth || (n.excludeRoot ? 1 : 0)) < n.maxLevels) && (t.y0 >= 0 || i.parent)
                        })), (function(t) {
                            return t.id
                        })),
                        o = hi(n.label),
                        u = hi(n.color),
                        l = hi(n.strokeColor),
                        s = hi(n.nodeClassName),
                        c = Hr().duration(n.transitionDuration),
                        f = n.layoutData[0].y1 - n.layoutData[0].y0,
                        h = Math.min(1, i.y0 + f * Math.min(i.hasOwnProperty("height") ? i.height + 1 : 1 / 0, n.maxLevels || 1 / 0));
                    n.svg.transition(c).tween("scale", (function() {
                        var t = yn(n.angleScale.domain(), [i.x0, i.x1]),
                            e = yn(n.radiusScale.domain(), [i.y0, h]);
                        return function(r) {
                            n.angleScale.domain(t(r)), n.radiusScale.domain(e(r))
                        }
                    }));
                    var p = a.exit().transition(c).style("opacity", 0).remove();
                    p.select("path.main-arc").attrTween("d", (function(t) {
                        return function() {
                            return n.arc(t)
                        }
                    })), p.select("path.hidden-arc").attrTween("d", (function(t) {
                        return function() {
                            return w(t)
                        }
                    }));
                    var d = a.enter().append("g").style("opacity", 0).on("click", (function(t, r) {
                        t.stopPropagation(), (n.onClick || e.focusOnNode)(r.data)
                    })).on("mouseover", (function(t, e) {
                        t.stopPropagation(), n.onHover && n.onHover(e.data), n.tooltip.style("display", n.showTooltip(e.data, e) ? "inline" : "none"), n.tooltip.html('<div class="tooltip-title">'.concat(n.tooltipTitle ? n.tooltipTitle(e.data, e) : function(t) {
                            for (var n = [], e = t; e;) n.unshift(e), e = e.parent;
                            return n
                        }(e).slice(n.excludeRoot ? 1 : 0).map((function(t) {
                            return o(t.data)
                        })).join(" &rarr; "), "</div>").concat(n.tooltipContent(e.data, e)))
                    })).on("mouseout", (function() {
                        n.tooltip.style("display", "none")
                    }));
                    d.append("path").attr("class", "main-arc").style("stroke", (function(t) {
                        return l(t.data, t.parent)
                    })).style("fill", (function(t) {
                        return u(t.data, t.parent)
                    })), d.append("path").attr("class", "hidden-arc").attr("id", (function(t) {
                        return "hidden-arc-".concat(n.chartId, "-").concat(t.id)
                    }));
                    var y = d.append("text").attr("class", "angular-label");
                    y.append("textPath").attr("class", "text-contour").attr("startOffset", "50%").attr("xlink:href", (function(t) {
                        return "#hidden-arc-".concat(n.chartId, "-").concat(t.id)
                    })), y.append("textPath").attr("class", "text-stroke").attr("startOffset", "50%").attr("xlink:href", (function(t) {
                        return "#hidden-arc-".concat(n.chartId, "-").concat(t.id)
                    }));
                    var v = d.append("g").attr("class", "radial-label");
                    v.append("text").attr("class", "text-contour"), v.append("text").attr("class", "text-stroke");
                    var g = a.merge(d);
                    g.style("opacity", 1).attr("class", (function(n) {
                        return ["slice"].concat(t("".concat(s(n.data) || "").split(" ").map((function(t) {
                            return t.trim()
                        })))).filter((function(t) {
                            return t
                        })).join(" ")
                    })), g.select("path.main-arc").transition(c).attrTween("d", (function(t) {
                        return function() {
                            return n.arc(t)
                        }
                    })).style("stroke", (function(t) {
                        return l(t.data, t.parent)
                    })).style("fill", (function(t) {
                        return u(t.data, t.parent)
                    }));
                    var m = n.showLabels && ["angular", "auto"].includes(n.labelOrientation.toLowerCase()),
                        _ = n.showLabels && ["radial", "auto"].includes(n.labelOrientation.toLowerCase());
                    m && g.select("path.hidden-arc").transition(c).attrTween("d", (function(t) {
                        return function() {
                            return w(t)
                        }
                    })), g.select("text.angular-label").select("textPath.text-contour"), g.select("text.angular-label").select("textPath.text-stroke"), g.select("g.radial-label").select("text.text-contour"), g.select("g.radial-label").select("text.text-stroke"), g.select(".angular-label").transition(c).styleTween("display", (function(t) {
                        return function() {
                            return m && ("auto" === n.labelOrientation ? "angular" === M(t) : x(t)) ? null : "none"
                        }
                    })), g.select(".radial-label").transition(c).styleTween("display", (function(t) {
                        return function() {
                            return _ && ("auto" === n.labelOrientation ? "radial" === M(t) : b(t)) ? null : "none"
                        }
                    })), m && g.selectAll("text.angular-label").selectAll("textPath").text((function(t) {
                        return o(t.data)
                    })), _ && g.selectAll("g.radial-label").selectAll("text").text((function(t) {
                        return o(t.data)
                    })).transition(c).attrTween("transform", (function(t) {
                        return function() {
                            return function(t) {
                                var e = (n.angleScale(t.x0) + n.angleScale(t.x1) - Math.PI) / 2,
                                    r = Math.max(0, (n.radiusScale(t.y0) + n.radiusScale(t.y1)) / 2),
                                    i = r * Math.cos(e),
                                    a = r * Math.sin(e),
                                    o = 180 * e / Math.PI;
                                return e > Math.PI / 2 && e < 3 * Math.PI / 2 && (o += 180), "translate(".concat(i, ", ").concat(a, ") rotate(").concat(o, ")")
                            }(t)
                        }
                    }))
                }

                function w(t) {
                    var e = Math.PI / 2,
                        r = [n.angleScale(t.x0) - e, n.angleScale(t.x1) - e],
                        i = Math.max(0, (n.radiusScale(t.y0) + n.radiusScale(t.y1)) / 2);
                    if (!(i && r[1] - r[0])) return "";
                    var a = (r[1] + r[0]) / 2,
                        o = a > 0 && a < Math.PI;
                    o && r.reverse();
                    var u = ve();
                    return u.arc(0, 0, i, r[0], r[1], o), u.toString()
                }

                function x(t) {
                    var e = n.angleScale(t.x1) - n.angleScale(t.x0),
                        r = Math.max(0, (n.radiusScale(t.y0) + n.radiusScale(t.y1)) / 2) * e;
                    return 7 * o(t.data).toString().length < r
                }

                function b(t) {
                    if (n.radiusScale(t.y0) * (n.angleScale(t.x1) - n.angleScale(t.x0)) < 14) return !1;
                    var e = n.radiusScale(t.y1) - n.radiusScale(t.y0);
                    return 7 * o(t.data).toString().length < e
                }

                function M(t) {
                    var e = (n.angleScale(t.x0) + n.angleScale(t.x1)) / 2 % Math.PI;
                    return e > Math.PI / 4 && e < 3 * Math.PI / 4 ? b(t) ? "radial" : x(t) ? "angular" : null : x(t) ? "angular" : b(t) ? "radial" : null
                }
            }
        }, Jr = Qr.stateInit, ti = void 0 === Jr ? function() {
            return {}
        } : Jr, ni = Qr.props, ei = void 0 === ni ? {} : ni, ri = Qr.methods, ii = void 0 === ri ? {} : ri, ai = Qr.aliases, oi = void 0 === ai ? {} : ai, ui = Qr.init, li = void 0 === ui ? function() {} : ui, si = Qr.update, ci = void 0 === si ? function() {} : si, fi = Object.keys(ei).map((function(t) {
            return new Kr(t, ei[t])
        })),
        function() {
            var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
                n = Object.assign({}, ti instanceof Function ? ti(t) : ti, {
                    initialised: !1
                }),
                e = {};

            function r(n) {
                return i(n, t), a(), r
            }
            var i = function(t, e) {
                    li.call(r, t, n, e), n.initialised = !0
                },
                a = Gr((function() {
                    n.initialised && (ci.call(r, n, e), e = {})
                }), 1);
            return fi.forEach((function(t) {
                r[t.name] = function(t) {
                    var i = t.name,
                        o = t.triggerUpdate,
                        u = void 0 !== o && o,
                        l = t.onChange,
                        s = void 0 === l ? function(t, n) {} : l,
                        c = t.defaultVal,
                        f = void 0 === c ? null : c;
                    return function(t) {
                        var o = n[i];
                        if (!arguments.length) return o;
                        var l = void 0 === t ? f : t;
                        return n[i] = l, s.call(r, l, n, o), !e.hasOwnProperty(i) && (e[i] = o), u && a(), r
                    }
                }(t)
            })), Object.keys(ii).forEach((function(t) {
                r[t] = function() {
                    for (var e, i = arguments.length, a = new Array(i), o = 0; o < i; o++) a[o] = arguments[o];
                    return (e = ii[t]).call.apply(e, [r, n].concat(a))
                }
            })), Object.entries(oi).forEach((function(t) {
                var n = Zr(t, 2),
                    e = n[0],
                    i = n[1];
                return r[e] = r[i]
            })), r.resetProps = function() {
                return fi.forEach((function(t) {
                    r[t.name](t.defaultVal)
                })), r
            }, r.resetProps(), n._rerender = a, r
        }
}));
